/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteParameter {
    private Map<String, String> userMeta = null;
    private float defaultQuality = 0.75f;
    private int[] horizontalSamp = new int[4];
    private int[] verticalSamp = new int[4];
    private boolean qualitySet = false;
    private boolean samplingSet = false;
    private QuantAlgorithm quantAlgorithm = QuantAlgorithm.OctTree;

    public WriteParameter(Map<String, String> userMeta) {
        this.userMeta = userMeta;
    }

    public WriteParameter(QuantAlgorithm quantAlg) {
        this.quantAlgorithm = quantAlg;
    }

    public WriteParameter() {
    }

    public boolean isQualitySet() {
        return this.qualitySet;
    }

    public boolean isSamplingSet() {
        return this.samplingSet;
    }

    public void reset() {
        this.qualitySet = false;
        this.samplingSet = false;
        for (int i = 0; i < 4; ++i) {
            this.horizontalSamp[i] = 0;
            this.verticalSamp[i] = 0;
        }
    }

    public void setHorizontalSubsampling(int component, int subsample) {
        this.samplingSet = true;
        this.horizontalSamp[component] = subsample;
    }

    public void setVerticalSubsampling(int component, int subsample) {
        this.samplingSet = true;
        this.verticalSamp[component] = subsample;
    }

    public int getVerticalSubsampling(int component) {
        return this.verticalSamp[component];
    }

    public int getHorizontalSubsampling(int component) {
        return this.horizontalSamp[component];
    }

    public Map<String, String> getUserMeta() {
        return this.userMeta;
    }

    public void setUserMeta(Map<String, String> userMeta) {
        this.userMeta = userMeta;
    }

    public float getDefaultQuality() {
        return this.defaultQuality;
    }

    public void setDefaultQuality(float defaultQuality) {
        this.qualitySet = true;
        this.defaultQuality = defaultQuality;
    }

    public QuantAlgorithm getQuantAlgorithm() {
        return this.quantAlgorithm;
    }

    public void setQuantAlgorithm(QuantAlgorithm quantAlgorithm) {
        this.quantAlgorithm = quantAlgorithm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuantAlgorithm {
        OctTree,
        NeuQuant,
        MedianCut;

    }
}

