/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T> {
    private static final Logger logger = Logger.getLogger(TransmittableThreadLocal.class.getName());
    private static InheritableThreadLocal<Map<TransmittableThreadLocal<?>, ?>> holder = new InheritableThreadLocal<Map<TransmittableThreadLocal<?>, ?>>(){

        @Override
        protected Map<TransmittableThreadLocal<?>, ?> initialValue() {
            return new WeakHashMap();
        }

        @Override
        protected Map<TransmittableThreadLocal<?>, ?> childValue(Map<TransmittableThreadLocal<?>, ?> parentValue) {
            return new WeakHashMap(parentValue);
        }
    };

    protected T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (null != value) {
            this.addValue();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (null == value) {
            this.removeValue();
        } else {
            this.addValue();
        }
    }

    @Override
    public final void remove() {
        this.removeValue();
        super.remove();
    }

    void superRemove() {
        super.remove();
    }

    T copyValue() {
        return this.copy(this.get());
    }

    private void addValue() {
        if (!((Map)holder.get()).containsKey(this)) {
            ((Map)holder.get()).put(this, null);
        }
    }

    private void removeValue() {
        ((Map)holder.get()).remove(this);
    }

    private static void doExecuteCallback(boolean isBefore) {
        for (Map.Entry entry : ((Map)holder.get()).entrySet()) {
            TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)entry.getKey();
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "TTL exception when " + (isBefore ? "beforeExecute" : "afterExecute") + ", cause: " + t.toString(), t);
            }
        }
    }

    static void dump(String title) {
        if (title != null && title.length() > 0) {
            System.out.printf("Start TransmittableThreadLocal[%s] Dump...\n", title);
        } else {
            System.out.println("Start TransmittableThreadLocal Dump...");
        }
        for (Map.Entry entry : ((Map)holder.get()).entrySet()) {
            TransmittableThreadLocal key = (TransmittableThreadLocal)entry.getKey();
            System.out.println(key.get());
        }
        System.out.println("TransmittableThreadLocal Dump end!");
    }

    static void dump() {
        TransmittableThreadLocal.dump(null);
    }

    public static class Transmitter {
        public static Object capture() {
            HashMap captured = new HashMap();
            for (TransmittableThreadLocal threadLocal : ((Map)holder.get()).keySet()) {
                captured.put(threadLocal, threadLocal.copyValue());
            }
            return captured;
        }

        public static Object replay(Object captured) {
            TransmittableThreadLocal threadLocal;
            Map capturedMap = (Map)captured;
            HashMap backup = new HashMap();
            Iterator iterator = ((Map)holder.get()).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                threadLocal = (TransmittableThreadLocal)next.getKey();
                backup.put(threadLocal, threadLocal.get());
                if (capturedMap.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            for (Map.Entry entry : capturedMap.entrySet()) {
                threadLocal = (TransmittableThreadLocal)entry.getKey();
                threadLocal.set(entry.getValue());
            }
            TransmittableThreadLocal.doExecuteCallback(true);
            return backup;
        }

        public static void restore(Object backup) {
            TransmittableThreadLocal threadLocal;
            Map backupMap = (Map)backup;
            TransmittableThreadLocal.doExecuteCallback(false);
            Iterator iterator = ((Map)holder.get()).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                threadLocal = (TransmittableThreadLocal)next.getKey();
                if (backupMap.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            for (Map.Entry entry : backupMap.entrySet()) {
                threadLocal = (TransmittableThreadLocal)entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R> R runSupplierWithCaptured(Object captured, Supplier<R> bizLogic) {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.get();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R> R runCallableWithCaptured(Object captured, Callable<R> bizLogic) throws Exception {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.call();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        private Transmitter() {
            throw new InstantiationError("Must not instantiate this class");
        }
    }
}

