/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.javassist.ClassPool;
import com.alibaba.ttl.javassist.CtClass;
import com.alibaba.ttl.javassist.LoaderClassPath;
import com.alibaba.ttl.threadpool.agent.JavassistTransformlet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TtlTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(TtlTransformer.class.getName());
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    final List<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();

    public TtlTransformer(Class<? extends JavassistTransformlet> ... transformletClasses) throws Exception {
        for (Class<? extends JavassistTransformlet> transformletClass : transformletClasses) {
            JavassistTransformlet transformlet = transformletClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.transformletList.add(transformlet);
            logger.info("[TtlTransformer] add Transformlet " + transformletClass + " success");
        }
    }

    @Override
    public final byte[] transform(ClassLoader loader, String classFile, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        try {
            if (classFile == null) {
                return EMPTY_BYTE_ARRAY;
            }
            String className = TtlTransformer.toClassName(classFile);
            for (JavassistTransformlet transformlet : this.transformletList) {
                if (!transformlet.needTransform(className)) continue;
                logger.info("Transforming class " + className);
                CtClass clazz = TtlTransformer.getCtClass(classFileBuffer, loader);
                transformlet.doTransform(clazz);
                return clazz.toBytecode();
            }
        }
        catch (Throwable t) {
            String msg = "Fail to transform class " + classFile + ", cause: " + t.toString();
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, msg, t);
            }
            throw new IllegalStateException(msg, t);
        }
        return EMPTY_BYTE_ARRAY;
    }

    private static String toClassName(String classFile) {
        return classFile.replace('/', '.');
    }

    private static CtClass getCtClass(byte[] classFileBuffer, ClassLoader classLoader) throws IOException {
        ClassPool classPool = new ClassPool(true);
        if (classLoader == null) {
            classPool.appendClassPath(new LoaderClassPath(ClassLoader.getSystemClassLoader()));
        } else {
            classPool.appendClassPath(new LoaderClassPath(classLoader));
        }
        CtClass clazz = classPool.makeClass(new ByteArrayInputStream(classFileBuffer), false);
        clazz.defrost();
        return clazz;
    }
}

