/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet;

import com.alibaba.ttl.javassist.CannotCompileException;
import com.alibaba.ttl.javassist.CtClass;
import com.alibaba.ttl.javassist.CtMethod;
import com.alibaba.ttl.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.JavassistTransformlet;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class TtlExecutorTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlExecutorTransformlet.class.getName());
    private static final String TTL_RUNNABLE_CLASS_NAME = "com.alibaba.ttl.TtlRunnable";
    private static final String TTL_CALLABLE_CLASS_NAME = "com.alibaba.ttl.TtlCallable";
    private static final String RUNNABLE_CLASS_NAME = "java.lang.Runnable";
    private static final String CALLABLE_CLASS_NAME = "java.util.concurrent.Callable";
    private static Set<String> EXECUTOR_CLASS_NAMES = new HashSet<String>();

    @Override
    public boolean needTransform(String className) {
        return EXECUTOR_CLASS_NAMES.contains(className);
    }

    @Override
    public void doTransform(CtClass clazz) throws NotFoundException, CannotCompileException, IOException {
        for (CtMethod method : clazz.getDeclaredMethods()) {
            this.updateMethodOfExecutorClass(clazz, method);
        }
    }

    private void updateMethodOfExecutorClass(CtClass clazz, CtMethod method) throws NotFoundException, CannotCompileException {
        if (method.getDeclaringClass() != clazz) {
            return;
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
            return;
        }
        CtClass[] parameterTypes = method.getParameterTypes();
        StringBuilder insertCode = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String code;
            CtClass paraType = parameterTypes[i];
            if (RUNNABLE_CLASS_NAME.equals(paraType.getName())) {
                code = String.format("$%d = %s.get($%d, false, true);", i + 1, TTL_RUNNABLE_CLASS_NAME, i + 1);
                logger.info("insert code before method " + method + " of class " + method.getDeclaringClass().getName() + ": " + code);
                insertCode.append(code);
                continue;
            }
            if (!CALLABLE_CLASS_NAME.equals(paraType.getName())) continue;
            code = String.format("$%d = %s.get($%d, false, true);", i + 1, TTL_CALLABLE_CLASS_NAME, i + 1);
            logger.info("insert code before method " + method + " of class " + method.getDeclaringClass().getName() + ": " + code);
            insertCode.append(code);
        }
        if (insertCode.length() > 0) {
            method.insertBefore(insertCode.toString());
        }
    }

    static {
        EXECUTOR_CLASS_NAMES.add("java.util.concurrent.ThreadPoolExecutor");
        EXECUTOR_CLASS_NAMES.add("java.util.concurrent.ScheduledThreadPoolExecutor");
    }
}

