/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.transformlet;

import com.alibaba.ttl.javassist.CannotCompileException;
import com.alibaba.ttl.javassist.CtClass;
import com.alibaba.ttl.javassist.CtField;
import com.alibaba.ttl.javassist.CtMethod;
import com.alibaba.ttl.javassist.CtNewMethod;
import com.alibaba.ttl.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.JavassistTransformlet;
import java.io.IOException;
import java.util.logging.Logger;

public class TtlForkJoinTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlForkJoinTransformlet.class.getName());
    private static final String FORK_JOIN_TASK_CLASS_NAME = "java.util.concurrent.ForkJoinTask";
    private static final String TTL_RECURSIVE_ACTION_CLASS_NAME = "com.alibaba.ttl.TtlRecursiveAction";
    private static final String TTL_RECURSIVE_TASK_CLASS_NAME = "com.alibaba.ttl.TtlRecursiveTask";

    @Override
    public boolean needTransform(String className) {
        return FORK_JOIN_TASK_CLASS_NAME.equals(className);
    }

    @Override
    public void doTransform(CtClass clazz) throws NotFoundException, CannotCompileException, IOException {
        this.updateForkJoinTaskClass(clazz);
    }

    private void updateForkJoinTaskClass(CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        String capturedFieldName = "captured$field$add$by$ttl";
        CtField capturedField = CtField.make("private final java.lang.Object captured$field$add$by$ttl;", clazz);
        clazz.addField(capturedField, "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.capture();");
        logger.info("add new field captured$field$add$by$ttl to class " + className);
        String doExec_methodName = "doExec";
        CtMethod doExecMethod = clazz.getDeclaredMethod("doExec");
        CtMethod new_doExecMethod = CtNewMethod.copy(doExecMethod, "doExec", clazz, null);
        String original_doExec_method_rename = "original$doExec$method$renamed$by$ttl";
        doExecMethod.setName("original$doExec$method$renamed$by$ttl");
        doExecMethod.setModifiers(doExecMethod.getModifiers() & 0xFFFFFFFE | 2);
        String code = "{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\njava.lang.Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}";
        new_doExecMethod.setBody("{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\njava.lang.Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
        clazz.addMethod(new_doExecMethod);
        logger.info("insert code around method " + doExecMethod + " of class " + className + ": " + "{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\njava.lang.Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
    }
}

