/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOfflineMaterialImageUploadDefaultResponse;
import com.alipay.v3.model.AlipayOfflineMaterialImageUploadModel;
import com.alipay.v3.model.AlipayOfflineMaterialImageUploadResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOfflineMaterialImageApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOfflineMaterialImageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOfflineMaterialImageApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call uploadCall(AlipayOfflineMaterialImageUploadModel data, File imageContent, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/offline/material/image/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent())) {
            localVarFormParams.put("data", customizedParams.getBodyContent());
        }
        if (imageContent != null) {
            localVarFormParams.put("image_content", imageContent);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadValidateBeforeCall(AlipayOfflineMaterialImageUploadModel data, File imageContent, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.uploadCall(data, imageContent, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOfflineMaterialImageUploadResponseModel upload(AlipayOfflineMaterialImageUploadModel data, File imageContent) throws ApiException {
        ApiResponse<AlipayOfflineMaterialImageUploadResponseModel> localVarResp = this.uploadWithHttpInfo(data, imageContent, null);
        return localVarResp.getData();
    }

    public AlipayOfflineMaterialImageUploadResponseModel upload(AlipayOfflineMaterialImageUploadModel data, File imageContent, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOfflineMaterialImageUploadResponseModel> localVarResp = this.uploadWithHttpInfo(data, imageContent, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOfflineMaterialImageUploadResponseModel> uploadWithHttpInfo(AlipayOfflineMaterialImageUploadModel data, File imageContent, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(data, imageContent, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOfflineMaterialImageUploadResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOfflineMaterialImageUploadDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call uploadAsync(AlipayOfflineMaterialImageUploadModel data, File imageContent, ApiCallback<AlipayOfflineMaterialImageUploadResponseModel> _callback) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(data, imageContent, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOfflineMaterialImageUploadResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadAsync(AlipayOfflineMaterialImageUploadModel data, File imageContent, ApiCallback<AlipayOfflineMaterialImageUploadResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(data, imageContent, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOfflineMaterialImageUploadResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

