/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayUserCertifyOpenInitializeDefaultResponse;
import com.alipay.v3.model.AlipayUserCertifyOpenInitializeModel;
import com.alipay.v3.model.AlipayUserCertifyOpenInitializeResponseModel;
import com.alipay.v3.model.AlipayUserCertifyOpenQueryDefaultResponse;
import com.alipay.v3.model.AlipayUserCertifyOpenQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayUserCertifyOpenApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayUserCertifyOpenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayUserCertifyOpenApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call initializeCall(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayUserCertifyOpenInitializeModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayUserCertifyOpenInitializeModel;
        String localVarPath = "/v3/alipay/user/certify/open/initialize";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call initializeValidateBeforeCall(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.initializeCall(alipayUserCertifyOpenInitializeModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayUserCertifyOpenInitializeResponseModel initialize(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel) throws ApiException {
        ApiResponse<AlipayUserCertifyOpenInitializeResponseModel> localVarResp = this.initializeWithHttpInfo(alipayUserCertifyOpenInitializeModel, null);
        return localVarResp.getData();
    }

    public AlipayUserCertifyOpenInitializeResponseModel initialize(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayUserCertifyOpenInitializeResponseModel> localVarResp = this.initializeWithHttpInfo(alipayUserCertifyOpenInitializeModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayUserCertifyOpenInitializeResponseModel> initializeWithHttpInfo(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.initializeValidateBeforeCall(alipayUserCertifyOpenInitializeModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenInitializeResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserCertifyOpenInitializeDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call initializeAsync(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, ApiCallback<AlipayUserCertifyOpenInitializeResponseModel> _callback) throws ApiException {
        Call localVarCall = this.initializeValidateBeforeCall(alipayUserCertifyOpenInitializeModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenInitializeResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call initializeAsync(AlipayUserCertifyOpenInitializeModel alipayUserCertifyOpenInitializeModel, ApiCallback<AlipayUserCertifyOpenInitializeResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.initializeValidateBeforeCall(alipayUserCertifyOpenInitializeModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenInitializeResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String certifyId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/user/certify/open/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (certifyId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("certify_id", certifyId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String certifyId, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(certifyId, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayUserCertifyOpenQueryResponseModel query(String certifyId) throws ApiException {
        ApiResponse<AlipayUserCertifyOpenQueryResponseModel> localVarResp = this.queryWithHttpInfo(certifyId, null);
        return localVarResp.getData();
    }

    public AlipayUserCertifyOpenQueryResponseModel query(String certifyId, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayUserCertifyOpenQueryResponseModel> localVarResp = this.queryWithHttpInfo(certifyId, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayUserCertifyOpenQueryResponseModel> queryWithHttpInfo(String certifyId, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(certifyId, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayUserCertifyOpenQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String certifyId, ApiCallback<AlipayUserCertifyOpenQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(certifyId, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String certifyId, ApiCallback<AlipayUserCertifyOpenQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(certifyId, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayUserCertifyOpenQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

