/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.rule;

import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.enums.AttrRuleTypeEnum;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import org.dom4j.Element;

public class AttributeRule {
    private String name;
    private AttrRuleTypeEnum type;
    private String value;

    public Element toElement(String attributeId) throws ServiceSchemaException {
        Element rule = XmlUtils.createRootElement("rule");
        if (this.type == null) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_TYPE_ERROR, attributeId);
        }
        if (StringUtil.isEmpty(this.name)) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_NAME_ERROR, attributeId);
        }
        if (StringUtil.isEmpty(this.value)) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_RULE_VALUE_ERROR, attributeId);
        }
        rule.addAttribute("type", this.getType().getCode());
        rule.addAttribute("name", this.name);
        rule.addAttribute("value", this.value);
        return rule;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttrRuleTypeEnum getType() {
        return this.type;
    }

    public void setType(AttrRuleTypeEnum type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

