/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.cache.CacheDigestTask;
import com.alipay.sofa.registry.server.data.event.StartTaskEvent;
import com.alipay.sofa.registry.server.data.event.handler.AbstractEventHandler;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.dataserver.task.AbstractTask;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Resource;

public class StartTaskEventHandler
extends AbstractEventHandler<StartTaskEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTaskEventHandler.class);
    @Resource(name="tasks")
    private List<AbstractTask> tasks;
    private ScheduledExecutorService executor = null;

    @Override
    public Class interest() {
        return StartTaskEvent.class;
    }

    @Override
    public void doHandle(StartTaskEvent event) {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = ExecutorFactory.newScheduledThreadPool(this.tasks.size(), this.getClass().getSimpleName());
            for (AbstractTask task : this.tasks) {
                LOGGER.info("[StartTaskEventHandler] start task:{}", (Object)task.getName());
                this.executor.scheduleWithFixedDelay(task, task.getInitialDelay(), task.getDelay(), task.getTimeUnit());
                LOGGER.info("[StartTaskEventHandler] start task:{} success", (Object)task.getName());
            }
            new CacheDigestTask().start();
        }
    }
}

