/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.filter.Filter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class RpcFilterContainer {
    private List<String> filterIds = new CopyOnWriteArrayList<String>();
    private List<String> filterClasses = new CopyOnWriteArrayList<String>();
    private boolean alreadyLoad = false;
    private final Object LOAD_LOCK = new Object();
    private List<Filter> filters = new CopyOnWriteArrayList<Filter>();
    private static final RpcFilterContainer INSTANCE = new RpcFilterContainer();

    public static RpcFilterContainer getInstance() {
        return INSTANCE;
    }

    public void addFilterId(String filterId) {
        if (StringUtils.hasText((String)filterId)) {
            this.filterIds.add(filterId);
        }
    }

    public void addFilterClass(String filterClass) {
        if (StringUtils.hasText((String)filterClass)) {
            this.filterClasses.add(filterClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Filter> getFilters(ApplicationContext applicationContext) {
        if (applicationContext != null) {
            if (!this.alreadyLoad) {
                Object object = this.LOAD_LOCK;
                synchronized (object) {
                    if (!this.alreadyLoad) {
                        this.loadFilters(applicationContext);
                        this.alreadyLoad = true;
                    }
                }
            }
            return this.filters;
        }
        throw new SofaBootRpcRuntimeException("The applicationContext should not be null");
    }

    private void loadFilters(ApplicationContext applicationContext) {
        for (String filterId : this.filterIds) {
            this.filters.add((Filter)applicationContext.getBean(filterId, Filter.class));
        }
        for (String clazz : this.filterClasses) {
            Class<?> filterClass;
            try {
                filterClass = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new SofaBootRpcRuntimeException("Can not find filter class " + clazz + " ", e);
            }
            if (Filter.class.isAssignableFrom(filterClass)) {
                try {
                    this.filters.add((Filter)filterClass.newInstance());
                    continue;
                }
                catch (Exception e) {
                    throw new SofaBootRpcRuntimeException("Error happen when create instance of " + filterClass + " ", e);
                }
            }
            throw new SofaBootRpcRuntimeException("The class of " + clazz + " should be a subclass of Filter");
        }
    }
}

