/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.context;

import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartAfterEvent;
import com.alipay.sofa.rpc.boot.context.event.SofaBootRpcStartEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class RpcStartApplicationListener
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private final AtomicBoolean published = new AtomicBoolean(false);
    private final AtomicBoolean success = new AtomicBoolean(false);
    private ApplicationContext applicationContext;
    private boolean enableAutoPublish;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext()) && this.enableAutoPublish) {
            this.publishRpcStartEvent();
        }
    }

    public void publishRpcStartEvent() {
        if (this.published.compareAndSet(false, true)) {
            this.applicationContext.publishEvent((ApplicationEvent)new SofaBootRpcStartEvent(this.applicationContext));
            this.applicationContext.publishEvent((ApplicationEvent)new SofaBootRpcStartAfterEvent(this.applicationContext));
            this.success.compareAndSet(false, true);
        }
    }

    public boolean isSuccess() {
        return this.success.get();
    }

    public boolean isEnableAutoPublish() {
        return this.enableAutoPublish;
    }

    public void setEnableAutoPublish(boolean enableAutoPublish) {
        this.enableAutoPublish = enableAutoPublish;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

