/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter.processor;

import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ConsumerConfigProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProviderConfigProcessor;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import java.util.List;

public class ProcessorContainer {
    private final List<ProviderConfigProcessor> providerProcessors;
    private final List<ConsumerConfigProcessor> consumerProcessors;

    public ProcessorContainer(List<ProviderConfigProcessor> providerProcessors, List<ConsumerConfigProcessor> consumerProcessors) {
        this.providerProcessors = providerProcessors;
        this.consumerProcessors = consumerProcessors;
    }

    public void processorConsumer(ConsumerConfig consumerConfig) {
        if (CommonUtils.isNotEmpty(this.consumerProcessors)) {
            for (ConsumerConfigProcessor consumerProcessor : this.consumerProcessors) {
                consumerProcessor.processorConsumer(consumerConfig);
            }
        }
    }

    public void processorProvider(ProviderConfig providerConfig) {
        if (CommonUtils.isNotEmpty(this.providerProcessors)) {
            for (ProviderConfigProcessor providerProcessor : this.providerProcessors) {
                providerProcessor.processorProvider(providerConfig);
            }
        }
    }
}

