/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.swagger;

import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingType;
import com.alipay.sofa.rpc.boot.swagger.SwaggerService;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.GenericOpenApiContext;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.OpenApiContextLocator;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Set;
import java.util.stream.Collectors;

public class SwaggerServiceImpl
implements SwaggerService {
    private final ComponentManager componentManager;
    private volatile OpenAPI openapi;
    private Set<String> restfulServices;

    public SwaggerServiceImpl(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String openapi() {
        if (this.openapi == null) {
            SwaggerServiceImpl swaggerServiceImpl = this;
            synchronized (swaggerServiceImpl) {
                if (this.openapi == null) {
                    this.openapi = this.buildOpenApi();
                }
            }
        }
        if (!this.getAllRestfulService().equals(this.restfulServices)) {
            SwaggerServiceImpl swaggerServiceImpl = this;
            synchronized (swaggerServiceImpl) {
                if (!this.getAllRestfulService().equals(this.restfulServices)) {
                    this.openapi = this.updateOpenApi();
                }
            }
        }
        return Json.pretty((Object)this.openapi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI updateOpenApi() {
        OpenApiContext openApiContext = OpenApiContextLocator.getInstance().getOpenApiContext("openapi.context.id.default");
        if (openApiContext instanceof GenericOpenApiContext) {
            this.restfulServices = this.getAllRestfulService();
            SwaggerConfiguration oasConfig = new SwaggerConfiguration().resourceClasses(this.restfulServices);
            ((GenericOpenApiContext)openApiContext).getOpenApiScanner().setConfiguration((OpenAPIConfiguration)oasConfig);
            try {
                ((GenericOpenApiContext)openApiContext).setCacheTTL(0L);
                OpenAPI openAPI = openApiContext.read();
                return openAPI;
            }
            finally {
                ((GenericOpenApiContext)openApiContext).setCacheTTL(-1L);
            }
        }
        return null;
    }

    private OpenAPI buildOpenApi() {
        try {
            this.restfulServices = this.getAllRestfulService();
            SwaggerConfiguration oasConfig = new SwaggerConfiguration().resourceClasses(this.restfulServices);
            OpenApiContext oac = new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)oasConfig).buildContext(true);
            return oac.read();
        }
        catch (OpenApiConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Set<String> getAllRestfulService() {
        return this.componentManager.getComponentInfosByType(ServiceComponent.SERVICE_COMPONENT_TYPE).stream().filter(ci -> {
            ServiceComponent sc = (ServiceComponent)ci;
            return sc.getService().getBinding(RpcBindingType.REST_BINDING_TYPE) != null;
        }).map(sc -> ((ServiceComponent)sc).getService().getInterfaceType()).map(Class::getName).collect(Collectors.toSet());
    }
}

