/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.context;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.context.SpringContextImplementation;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class SpringContextComponent
extends AbstractComponent {
    public static ComponentType SPRING_COMPONENT_TYPE = new ComponentType("Spring");

    public SpringContextComponent(ComponentName componentName, Implementation implementation, SofaRuntimeContext sofaRuntimeContext) {
        this.implementation = implementation;
        this.componentName = componentName;
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public ComponentType getType() {
        return SPRING_COMPONENT_TYPE;
    }

    @Override
    public Map<String, Property> getProperties() {
        return null;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return (ApplicationContext)this.implementation.getTarget();
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        if (this.componentStatus != ComponentStatus.RESOLVED) {
            return;
        }
        this.componentStatus = ComponentStatus.ACTIVATED;
    }

    @Override
    public void deactivate() throws ServiceRuntimeException {
        if (this.implementation instanceof SpringContextImplementation) {
            AbstractApplicationContext applicationContext = (AbstractApplicationContext)this.implementation.getTarget();
            applicationContext.close();
        }
        super.deactivate();
    }
}

