/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.filter;

import com.alipay.sofa.runtime.filter.JvmFilter;
import com.alipay.sofa.runtime.filter.JvmFilterContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class JvmFilterHolder {
    private final List<JvmFilter> JVM_FILTERS = new ArrayList<JvmFilter>();
    private final AtomicBoolean FILTERS_SORTED = new AtomicBoolean(false);

    public void addJvmFilter(JvmFilter f) {
        this.JVM_FILTERS.add(f);
        this.FILTERS_SORTED.compareAndSet(true, false);
    }

    public void clearJvmFilters() {
        this.JVM_FILTERS.clear();
    }

    private void sortJvmFilters() {
        if (this.FILTERS_SORTED.compareAndSet(false, true)) {
            this.JVM_FILTERS.sort((Comparator<JvmFilter>)AnnotationAwareOrderComparator.INSTANCE);
        }
    }

    public List<JvmFilter> getJvmFilters() {
        this.sortJvmFilters();
        return this.JVM_FILTERS;
    }

    public static boolean beforeInvoking(JvmFilterContext context) {
        List<JvmFilter> filters = Collections.unmodifiableList(context.getSofaRuntimeContext().getJvmFilterHolder().getJvmFilters());
        for (JvmFilter filter : filters) {
            if (filter.before(context)) continue;
            return false;
        }
        return true;
    }

    public static boolean afterInvoking(JvmFilterContext context) {
        List<JvmFilter> filters = Collections.unmodifiableList(context.getSofaRuntimeContext().getJvmFilterHolder().getJvmFilters());
        for (int i = filters.size() - 1; i >= 0; --i) {
            if (filters.get(i).after(context)) continue;
            return false;
        }
        return true;
    }
}

