/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.async.AsyncInitMethodManager;
import com.alipay.sofa.runtime.async.AsyncInitializeBeanMethodInvoker;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class AsyncProxyBeanPostProcessor
implements BeanPostProcessor,
InitializingBean,
BeanFactoryAware,
Ordered {
    private final AsyncInitMethodManager asyncInitMethodManager;
    private ConfigurableListableBeanFactory beanFactory;

    public AsyncProxyBeanPostProcessor(AsyncInitMethodManager asyncInitMethodManager) {
        this.asyncInitMethodManager = asyncInitMethodManager;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        String methodName = this.asyncInitMethodManager.findAsyncInitMethod(this.beanFactory, beanName);
        if (!StringUtils.hasText((String)methodName)) {
            return bean;
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(bean.getClass());
        proxyFactory.setProxyTargetClass(true);
        AsyncInitializeBeanMethodInvoker asyncInitializeBeanMethodInvoker = new AsyncInitializeBeanMethodInvoker(this.asyncInitMethodManager, bean, beanName, methodName);
        proxyFactory.addAdvice((Advice)asyncInitializeBeanMethodInvoker);
        return proxyFactory.getProxy();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            String asyncInitMethodName = (String)beanDefinition.getAttribute("async-init-method-name");
            if (!StringUtils.hasText((String)asyncInitMethodName)) continue;
            this.asyncInitMethodManager.registerAsyncInitBean(this.beanFactory, beanName, asyncInitMethodName);
        }
    }
}

