/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.parser;

import com.alipay.sofa.runtime.spring.factory.ReferenceFactoryBean;
import com.alipay.sofa.runtime.spring.parser.AbstractContractDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ReferenceDefinitionParser
extends AbstractContractDefinitionParser {
    public static final String JVM_FIRST = "jvm-first";
    public static final String PROPERTY_JVM_FIRST = "jvmFirst";
    public static final String PROPERTY_LOAD_BALANCE = "loadBalance";
    public static final String REQUIRED = "required";

    @Override
    protected void doParseInternal(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String required;
        String loadBalance;
        String jvmFirstString = element.getAttribute(JVM_FIRST);
        if (StringUtils.hasText((String)jvmFirstString)) {
            if ("true".equalsIgnoreCase(jvmFirstString)) {
                builder.addPropertyValue(PROPERTY_JVM_FIRST, (Object)true);
            } else if ("false".equalsIgnoreCase(jvmFirstString)) {
                builder.addPropertyValue(PROPERTY_JVM_FIRST, (Object)false);
            } else {
                throw new RuntimeException("Invalid value of property jvm-first, can only be true or false.");
            }
        }
        if (StringUtils.hasText((String)(loadBalance = element.getAttribute(PROPERTY_LOAD_BALANCE)))) {
            builder.addPropertyValue(PROPERTY_LOAD_BALANCE, (Object)loadBalance);
        }
        if (StringUtils.hasText((String)(required = element.getAttribute(REQUIRED)))) {
            if ("true".equalsIgnoreCase(required)) {
                builder.addPropertyValue(REQUIRED, (Object)true);
            } else if ("false".equalsIgnoreCase(required)) {
                builder.addPropertyValue(REQUIRED, (Object)false);
            } else {
                throw new RuntimeException("Invalid value of property required, can only be true or false.");
            }
        }
        String interfaceType = element.getAttribute("interface");
        builder.getBeanDefinition().setAttribute("factoryBeanObjectType", (Object)this.getInterfaceClass(interfaceType));
    }

    protected Class getBeanClass(Element element) {
        return ReferenceFactoryBean.class;
    }

    public String supportTagName() {
        return "reference";
    }

    protected Class getInterfaceClass(String interfaceType) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(interfaceType);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to load class for interface: " + interfaceType, t);
        }
    }
}

