/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.autoconfigure.health;

import java.util.HashMap;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.Status;

public class SofaHttpCodeStatusMapper
implements HttpCodeStatusMapper {
    private SimpleHttpCodeStatusMapper statusMapper;

    public SofaHttpCodeStatusMapper(HealthEndpointProperties healthEndpointProperties) {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>(8);
        if (healthEndpointProperties.getStatus().getHttpMapping() != null) {
            mapping.putAll(healthEndpointProperties.getStatus().getHttpMapping());
        }
        mapping.put(Status.DOWN.getCode(), 503);
        mapping.put(Status.OUT_OF_SERVICE.getCode(), 500);
        mapping.put(Status.UNKNOWN.getCode(), 500);
        this.statusMapper = new SimpleHttpCodeStatusMapper(mapping);
    }

    public int getStatusCode(Status status) {
        return this.statusMapper.getStatusCode(status);
    }
}

