/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.autoconfigure.health;

import com.alipay.sofa.boot.actuator.autoconfigure.health.HealthProperties;
import com.alipay.sofa.boot.actuator.health.HealthCheckerProcessor;
import com.alipay.sofa.boot.actuator.health.HealthIndicatorProcessor;
import com.alipay.sofa.boot.actuator.health.ReadinessCheckCallbackProcessor;
import com.alipay.sofa.boot.actuator.health.ReadinessCheckListener;
import com.alipay.sofa.boot.actuator.health.ReadinessEndpoint;
import com.alipay.sofa.boot.constant.SofaBootConstants;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.common.thread.NamedThreadFactory;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(endpoint=ReadinessEndpoint.class)
@EnableConfigurationProperties(value={HealthProperties.class})
public class ReadinessAutoConfiguration {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(ReadinessAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={ReadinessCheckListener.class}, search=SearchStrategy.CURRENT)
    public ReadinessCheckListener readinessCheckListener(HealthCheckerProcessor healthCheckerProcessor, HealthIndicatorProcessor healthIndicatorProcessor, ReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor, ThreadPoolExecutor readinessHealthCheckExecutor, HealthProperties healthCheckProperties) {
        ReadinessCheckListener readinessCheckListener = new ReadinessCheckListener(healthCheckerProcessor, healthIndicatorProcessor, afterReadinessCheckCallbackProcessor);
        readinessCheckListener.setManualReadinessCallback(healthCheckProperties.isManualReadinessCallback());
        readinessCheckListener.setThrowExceptionWhenHealthCheckFailed(healthCheckProperties.isInsulator());
        readinessCheckListener.setSkipAll(healthCheckProperties.isSkipAll());
        readinessCheckListener.setSkipHealthChecker(healthCheckProperties.isSkipHealthChecker());
        readinessCheckListener.setSkipHealthIndicator(healthCheckProperties.isSkipHealthIndicator());
        readinessCheckListener.setHealthCheckExecutor(readinessHealthCheckExecutor);
        return readinessCheckListener;
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthCheckerProcessor healthCheckerProcessor(HealthProperties healthCheckProperties, ThreadPoolExecutor readinessHealthCheckExecutor) {
        HealthCheckerProcessor healthCheckerProcessor = new HealthCheckerProcessor();
        healthCheckerProcessor.setHealthCheckExecutor((ExecutorService)readinessHealthCheckExecutor);
        healthCheckerProcessor.setParallelCheck(healthCheckProperties.isParallelCheck());
        healthCheckerProcessor.setParallelCheckTimeout(healthCheckProperties.getParallelCheckTimeout());
        healthCheckerProcessor.setGlobalTimeout(healthCheckProperties.getGlobalHealthCheckerTimeout());
        healthCheckerProcessor.setHealthCheckerConfigs(healthCheckProperties.getHealthCheckerConfig());
        return healthCheckerProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthIndicatorProcessor healthIndicatorProcessor(HealthProperties healthCheckProperties, ThreadPoolExecutor readinessHealthCheckExecutor) {
        HealthIndicatorProcessor healthIndicatorProcessor = new HealthIndicatorProcessor();
        healthIndicatorProcessor.setHealthCheckExecutor((ExecutorService)readinessHealthCheckExecutor);
        healthIndicatorProcessor.initExcludedIndicators(healthCheckProperties.getExcludedIndicators());
        healthIndicatorProcessor.setParallelCheck(healthCheckProperties.isParallelCheck());
        healthIndicatorProcessor.setParallelCheckTimeout(healthCheckProperties.getParallelCheckTimeout());
        healthIndicatorProcessor.setGlobalTimeout(healthCheckProperties.getGlobalHealthIndicatorTimeout());
        healthIndicatorProcessor.setHealthIndicatorConfig(healthCheckProperties.getHealthIndicatorConfig());
        return healthIndicatorProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor() {
        return new ReadinessCheckCallbackProcessor();
    }

    @Bean(name={"readinessHealthCheckExecutor"})
    @ConditionalOnMissingBean(name={"readinessHealthCheckExecutor"})
    public ThreadPoolExecutor readinessHealthCheckExecutor(HealthProperties properties) {
        int threadPoolSize = properties.isParallelCheck() ? SofaBootConstants.CPU_CORE * 5 : 1;
        LOGGER.info("Create health-check thread pool, corePoolSize: {}, maxPoolSize: {}.", (Object)threadPoolSize, (Object)threadPoolSize);
        return new SofaThreadPoolExecutor(threadPoolSize, threadPoolSize, 30L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new NamedThreadFactory("health-check"), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), "health-check", "sofa-boot");
    }
}

