/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.autoconfigure.health;

import com.alipay.sofa.boot.actuator.autoconfigure.health.HealthProperties;
import com.alipay.sofa.boot.actuator.autoconfigure.health.ReadinessAutoConfiguration;
import com.alipay.sofa.boot.actuator.health.ReadinessCheckListener;
import com.alipay.sofa.boot.actuator.health.ReadinessEndpoint;
import com.alipay.sofa.boot.actuator.health.ReadinessEndpointWebExtension;
import com.alipay.sofa.boot.actuator.health.ReadinessHttpCodeStatusMapper;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={HealthEndpointAutoConfiguration.class}, after={ReadinessAutoConfiguration.class})
@ConditionalOnBean(value={ReadinessCheckListener.class})
@ConditionalOnAvailableEndpoint(endpoint=ReadinessEndpoint.class)
public class ReadinessEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ReadinessCheckListener.class})
    public ReadinessEndpoint readinessEndpoint(ReadinessCheckListener readinessCheckListener) {
        return new ReadinessEndpoint(readinessCheckListener);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint(endpoint=ReadinessEndpointWebExtension.class)
    public ReadinessEndpointWebExtension readinessEndpointWebExtension(ReadinessEndpoint readinessEndpoint, HttpCodeStatusMapper sofaHttpCodeStatusMapper) {
        return new ReadinessEndpointWebExtension(readinessEndpoint, sofaHttpCodeStatusMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpCodeStatusMapper readinessHttpCodeStatusMapper(HealthProperties healthProperties) {
        return new ReadinessHttpCodeStatusMapper(healthProperties.getStatus().getHttpMapping());
    }
}

