/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthCheckerComparatorProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class HealthCheckComparatorSupport {
    public static Comparator<Object> getComparatorToUse(BeanFactory beanFactory) {
        ObjectProvider objectProvider;
        HealthCheckerComparatorProvider healthCheckerComparatorProvider;
        Comparator<Object> comparatorToUse = null;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            comparatorToUse = ((DefaultListableBeanFactory)beanFactory).getDependencyComparator();
        }
        if (beanFactory != null && (healthCheckerComparatorProvider = (HealthCheckerComparatorProvider)(objectProvider = beanFactory.getBeanProvider(HealthCheckerComparatorProvider.class)).getIfUnique()) != null) {
            comparatorToUse = healthCheckerComparatorProvider.getComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = AnnotationAwareOrderComparator.INSTANCE;
        }
        return comparatorToUse;
    }

    public static <T, U> LinkedHashMap<T, U> sortMapAccordingToValue(Map<T, U> origin, Comparator<Object> comparatorToUse) {
        ArrayList<Map.Entry<T, U>> entryList = new ArrayList<Map.Entry<T, U>>(origin.entrySet());
        entryList.sort((o1, o2) -> comparatorToUse.compare(o1.getValue(), o2.getValue()));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : entryList) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

