/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthCheckComparatorSupport;
import com.alipay.sofa.boot.actuator.health.ReadinessCheckCallback;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.startup.BaseStat;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class ReadinessCheckCallbackProcessor
implements ApplicationContextAware {
    private static final Logger logger = SofaBootLoggerFactory.getLogger(ReadinessCheckCallbackProcessor.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final AtomicBoolean isInitiated = new AtomicBoolean(false);
    private final List<BaseStat> readinessCheckCallbackStartupStatList = new CopyOnWriteArrayList<BaseStat>();
    private ApplicationContext applicationContext;
    private LinkedHashMap<String, ReadinessCheckCallback> readinessCheckCallbacks = null;

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(ReadinessCheckCallback.class);
            this.readinessCheckCallbacks = HealthCheckComparatorSupport.sortMapAccordingToValue(beansOfType, HealthCheckComparatorSupport.getComparatorToUse((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory()));
            String applicationCallbackInfo = "Found " + this.readinessCheckCallbacks.size() + " ReadinessCheckCallback implementation: " + String.join((CharSequence)",", beansOfType.keySet());
            logger.info(applicationCallbackInfo);
        }
    }

    public boolean readinessCheckCallback(Map<String, Health> callbackDetails) {
        logger.info("Begin ReadinessCheckCallback readiness check");
        Assert.notNull(this.readinessCheckCallbacks, (String)"ReadinessCheckCallbacks must not be null.");
        boolean allResult = true;
        String failedBeanId = "";
        for (Map.Entry<String, ReadinessCheckCallback> entry : this.readinessCheckCallbacks.entrySet()) {
            String beanId = entry.getKey();
            if (allResult) {
                if (this.doHealthCheckCallback(beanId, entry.getValue(), callbackDetails)) continue;
                failedBeanId = beanId;
                allResult = false;
                continue;
            }
            logger.warn(beanId + " is skipped due to the failure of " + failedBeanId);
            callbackDetails.put(beanId, Health.down().withDetail("invoking", (Object)("skipped due to the failure of " + failedBeanId)).build());
        }
        if (allResult) {
            logger.info("ReadinessCheckCallback readiness check result: success.");
        } else {
            logger.error(ErrorCode.convert((String)"01-24000"));
        }
        return allResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHealthCheckCallback(String beanId, ReadinessCheckCallback readinessCheckCallback, Map<String, Health> callbackDetails) {
        Assert.notNull(callbackDetails, () -> "HealthCallbackDetails must not be null");
        boolean result = false;
        Health health = null;
        logger.info("ReadinessCheckCallback [{}] check start.", (Object)beanId);
        BaseStat baseStat = new BaseStat();
        baseStat.setName(beanId);
        baseStat.putAttribute("type", "readinessCheckCallbacn");
        baseStat.setStartTime(System.currentTimeMillis());
        try {
            health = readinessCheckCallback.onHealthy(this.applicationContext);
            result = health.getStatus().equals((Object)Status.UP);
            if (!result) {
                logger.error(ErrorCode.convert((String)"01-24001", (Object[])new Object[]{beanId, this.objectMapper.writeValueAsString((Object)health.getDetails())}));
            }
        }
        catch (Throwable t) {
            if (health == null) {
                health = new Health.Builder().down((Throwable)new RuntimeException(t)).build();
            }
            logger.error(ErrorCode.convert((String)"01-24002", (Object[])new Object[]{beanId}), t);
        }
        finally {
            callbackDetails.put(beanId, health);
        }
        baseStat.setEndTime(System.currentTimeMillis());
        this.readinessCheckCallbackStartupStatList.add(baseStat);
        return result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<BaseStat> getReadinessCheckCallbackStartupStatList() {
        return this.readinessCheckCallbackStartupStatList;
    }
}

