/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.rpc;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="rpc")
public class SofaRpcEndpoint {
    @ReadOperation
    public RpcServicesDescriptor rpcServices() {
        List<ProviderDescriptor> providerDescriptors = this.getProviderDescriptors();
        List<ConsumerDescriptor> consumerDescriptors = this.getConsumerDescriptors();
        List<RegistryDescriptor> registryDescriptors = this.getRegistryDescriptors();
        return new RpcServicesDescriptor(providerDescriptors, consumerDescriptors, registryDescriptors);
    }

    protected List<ProviderDescriptor> getProviderDescriptors() {
        List providerBootstraps = RpcRuntimeContext.getProviderConfigs();
        return providerBootstraps.stream().map(ProviderBootstrap::getProviderConfig).map(this::createProviderDescriptor).filter(Objects::nonNull).toList();
    }

    protected List<ConsumerDescriptor> getConsumerDescriptors() {
        List consumerBootstraps = RpcRuntimeContext.getConsumerConfigs();
        return consumerBootstraps.stream().map(ConsumerBootstrap::getConsumerConfig).map(this::createConsumerDescriptor).filter(Objects::nonNull).toList();
    }

    protected List<RegistryDescriptor> getRegistryDescriptors() {
        List registryConfigs = RegistryFactory.getRegistryConfigs();
        return registryConfigs.stream().map(this::createRegistryDescriptor).filter(Objects::nonNull).toList();
    }

    protected ProviderDescriptor createProviderDescriptor(ProviderConfig providerConfig) {
        String interfaceId = providerConfig.getInterfaceId();
        String uniqueId = providerConfig.getUniqueId();
        List serverConfigs = providerConfig.getServer();
        List<String> protocols = serverConfigs.stream().map(ServerConfig::getProtocol).filter(Objects::nonNull).toList();
        List registryConfigs = providerConfig.getRegistry();
        List<String> registries = registryConfigs.stream().map(RegistryConfig::getProtocol).filter(Objects::nonNull).toList();
        String serialization = providerConfig.getSerialization();
        boolean register = providerConfig.isRegister();
        String targetClassName = Optional.ofNullable(providerConfig.getRef()).map(object -> AopProxyUtils.ultimateTargetClass((Object)object).getName()).orElse(null);
        return new ProviderDescriptor(interfaceId, uniqueId, protocols, registries, serialization, register, targetClassName);
    }

    protected ConsumerDescriptor createConsumerDescriptor(ConsumerConfig consumerConfig) {
        String interfaceId = consumerConfig.getInterfaceId();
        String uniqueId = consumerConfig.getUniqueId();
        String protocol = consumerConfig.getProtocol();
        List registryConfigs = consumerConfig.getRegistry();
        List<String> registries = registryConfigs.stream().map(RegistryConfig::getProtocol).filter(Objects::nonNull).toList();
        String directUrl = consumerConfig.getDirectUrl();
        String invokeType = consumerConfig.getInvokeType();
        String serialization = consumerConfig.getSerialization();
        boolean subscribe = consumerConfig.isSubscribe();
        int timeout = consumerConfig.getTimeout();
        int retries = consumerConfig.getRetries();
        return new ConsumerDescriptor(interfaceId, uniqueId, protocol, registries, serialization, directUrl, invokeType, subscribe, timeout, retries);
    }

    protected RegistryDescriptor createRegistryDescriptor(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        String address = registryConfig.getAddress();
        String index = registryConfig.getIndex();
        return new RegistryDescriptor(protocol, address, index);
    }

    @JsonPropertyOrder(value={"provider", "consumer", "registry"})
    public static class RpcServicesDescriptor
    implements OperationResponseBody {
        private final List<ProviderDescriptor> providers;
        private final List<ConsumerDescriptor> consumers;
        private final List<RegistryDescriptor> registries;

        private RpcServicesDescriptor(List<ProviderDescriptor> providerDescriptors, List<ConsumerDescriptor> consumerDescriptors, List<RegistryDescriptor> registryDescriptors) {
            this.providers = providerDescriptors;
            this.consumers = consumerDescriptors;
            this.registries = registryDescriptors;
        }

        public List<ProviderDescriptor> getProvider() {
            return this.providers;
        }

        public List<ConsumerDescriptor> getConsumer() {
            return this.consumers;
        }

        public List<RegistryDescriptor> getRegistry() {
            return this.registries;
        }
    }

    public static class ProviderDescriptor {
        protected final String interfaceId;
        protected final String uniqueId;
        protected final List<String> protocols;
        protected final List<String> registries;
        protected final String serialization;
        protected final boolean register;
        protected final String targetClassName;
        protected final Map<String, Object> extraInfos = new HashMap<String, Object>();

        public ProviderDescriptor(String interfaceId, String uniqueId, List<String> protocols, List<String> registries, String serialization, boolean register, String targetClassName) {
            this.interfaceId = interfaceId;
            this.uniqueId = uniqueId;
            this.protocols = protocols;
            this.registries = registries;
            this.serialization = serialization;
            this.register = register;
            this.targetClassName = targetClassName;
        }

        public String getInterfaceId() {
            return this.interfaceId;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public List<String> getProtocols() {
            return this.protocols;
        }

        public List<String> getRegistries() {
            return this.registries;
        }

        public String getSerialization() {
            return this.serialization;
        }

        public boolean isRegister() {
            return this.register;
        }

        public String getTargetClassName() {
            return this.targetClassName;
        }

        public Map<String, Object> getExtraInfos() {
            return this.extraInfos;
        }
    }

    public static class ConsumerDescriptor {
        protected final String interfaceId;
        protected final String uniqueId;
        protected final String protocol;
        protected final List<String> registries;
        protected final String serialization;
        protected final String directUrl;
        protected final String invokeType;
        protected final boolean subscribe;
        protected final int timeout;
        protected final int retries;
        protected final Map<String, Object> extraInfos = new HashMap<String, Object>();

        public ConsumerDescriptor(String interfaceId, String uniqueId, String protocol, List<String> registries, String serialization, String directUrl, String invokeType, boolean subscribe, int timeout, int retries) {
            this.interfaceId = interfaceId;
            this.uniqueId = uniqueId;
            this.protocol = protocol;
            this.registries = registries;
            this.serialization = serialization;
            this.directUrl = directUrl;
            this.invokeType = invokeType;
            this.subscribe = subscribe;
            this.timeout = timeout;
            this.retries = retries;
        }

        public String getInterfaceId() {
            return this.interfaceId;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public List<String> getRegistries() {
            return this.registries;
        }

        public String getSerialization() {
            return this.serialization;
        }

        public String getDirectUrl() {
            return this.directUrl;
        }

        public String getInvokeType() {
            return this.invokeType;
        }

        public boolean isSubscribe() {
            return this.subscribe;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public int getRetries() {
            return this.retries;
        }

        public Map<String, Object> getExtraInfos() {
            return this.extraInfos;
        }
    }

    public static class RegistryDescriptor {
        protected final String protocol;
        protected final String address;
        protected final String index;

        public RegistryDescriptor(String protocol, String address, String index) {
            this.protocol = protocol;
            this.address = address;
            this.index = index;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }

        public String getIndex() {
            return this.index;
        }
    }
}

