/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.detect;

import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigurationImportEvent;
import org.springframework.boot.autoconfigure.AutoConfigurationImportListener;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class LegacyAutoConfigurationDetectListener
implements AutoConfigurationImportListener,
BeanClassLoaderAware {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(LegacyAutoConfigurationDetectListener.class);
    private ClassLoader beanClassLoader;

    public void onAutoConfigurationImportEvent(AutoConfigurationImportEvent event) {
        HashSet importConfigurations = new HashSet();
        importConfigurations.addAll(event.getCandidateConfigurations());
        importConfigurations.addAll(event.getExclusions());
        ArrayList configurations = new ArrayList(SpringFactoriesLoader.loadFactoryNames(EnableAutoConfiguration.class, (ClassLoader)this.beanClassLoader));
        HashSet<String> legacyConfigurations = new HashSet<String>();
        configurations.forEach(className -> {
            if (!importConfigurations.contains(className)) {
                legacyConfigurations.add((String)className);
            }
        });
        if (!legacyConfigurations.isEmpty()) {
            LOGGER.warn(this.builderWarnLog(legacyConfigurations).toString());
        }
    }

    private StringBuilder builderWarnLog(Set<String> legacyConfigurations) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("These configurations defined in spring.factories file will be ignored:");
        stringBuilder.append("\n");
        legacyConfigurations.forEach(legacyConfiguration -> {
            stringBuilder.append("--- ");
            stringBuilder.append((String)legacyConfiguration);
            stringBuilder.append("\n");
        });
        return stringBuilder;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

