/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.isle;

import com.alipay.sofa.boot.autoconfigure.isle.SofaModuleAvailableCondition;
import com.alipay.sofa.boot.autoconfigure.isle.SofaModuleProperties;
import com.alipay.sofa.boot.constant.SofaBootConstants;
import com.alipay.sofa.boot.context.ContextRefreshInterceptor;
import com.alipay.sofa.boot.context.processor.SofaPostProcessorShareFilter;
import com.alipay.sofa.boot.context.processor.SofaPostProcessorShareManager;
import com.alipay.sofa.boot.isle.ApplicationRuntimeModel;
import com.alipay.sofa.boot.isle.deployment.DefaultModuleDeploymentValidator;
import com.alipay.sofa.boot.isle.deployment.ModuleDeploymentValidator;
import com.alipay.sofa.boot.isle.loader.DynamicSpringContextLoader;
import com.alipay.sofa.boot.isle.loader.SpringContextLoader;
import com.alipay.sofa.boot.isle.profile.DefaultSofaModuleProfileChecker;
import com.alipay.sofa.boot.isle.profile.SofaModuleProfileChecker;
import com.alipay.sofa.boot.isle.spring.SofaModuleContextLifecycle;
import com.alipay.sofa.boot.isle.stage.DefaultPipelineContext;
import com.alipay.sofa.boot.isle.stage.ModelCreatingStage;
import com.alipay.sofa.boot.isle.stage.ModuleLogOutputStage;
import com.alipay.sofa.boot.isle.stage.PipelineContext;
import com.alipay.sofa.boot.isle.stage.PipelineStage;
import com.alipay.sofa.boot.isle.stage.SpringContextInstallStage;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.common.thread.NamedThreadFactory;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration
@Conditional(value={SofaModuleAvailableCondition.class})
@EnableConfigurationProperties(value={SofaModuleProperties.class})
public class SofaModuleAutoConfiguration {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(SofaModuleAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PipelineContext pipelineContext(List<PipelineStage> stageList) {
        DefaultPipelineContext pipelineContext = new DefaultPipelineContext();
        stageList.forEach(arg_0 -> ((PipelineContext)pipelineContext).appendStage(arg_0));
        return pipelineContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaModuleContextLifecycle sofaModuleContextLifecycle(PipelineContext pipelineContext) {
        return new SofaModuleContextLifecycle(pipelineContext);
    }

    @Bean(value={"APPLICATION_RUNTIME_MODEL"})
    @ConditionalOnMissingBean
    public ApplicationRuntimeModel applicationRuntimeModel(ModuleDeploymentValidator moduleDeploymentValidator, SofaModuleProfileChecker sofaModuleProfileChecker) {
        ApplicationRuntimeModel applicationRuntimeModel = new ApplicationRuntimeModel();
        applicationRuntimeModel.setModuleDeploymentValidator(moduleDeploymentValidator);
        applicationRuntimeModel.setSofaModuleProfileChecker(sofaModuleProfileChecker);
        return applicationRuntimeModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public ModelCreatingStage modelCreatingStage(SofaModuleProperties sofaModuleProperties, ApplicationRuntimeModel applicationRuntimeModel) {
        ModelCreatingStage modelCreatingStage = new ModelCreatingStage();
        sofaModuleProperties.getIgnoreModules().forEach(arg_0 -> ((ModelCreatingStage)modelCreatingStage).addIgnoreModule(arg_0));
        sofaModuleProperties.getIgnoreCalculateRequireModules().forEach(arg_0 -> ((ModelCreatingStage)modelCreatingStage).addIgnoredCalculateRequireModule(arg_0));
        modelCreatingStage.setAllowModuleOverriding(sofaModuleProperties.isAllowModuleOverriding());
        modelCreatingStage.setApplicationRuntimeModel(applicationRuntimeModel);
        return modelCreatingStage;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextInstallStage springContextInstallStage(SofaModuleProperties sofaModuleProperties, SpringContextLoader springContextLoader, ApplicationRuntimeModel applicationRuntimeModel) {
        SpringContextInstallStage springContextInstallStage = new SpringContextInstallStage();
        springContextInstallStage.setApplicationRuntimeModel(applicationRuntimeModel);
        springContextInstallStage.setSpringContextLoader(springContextLoader);
        springContextInstallStage.setModuleStartUpParallel(sofaModuleProperties.isModuleStartUpParallel());
        springContextInstallStage.setIgnoreModuleInstallFailure(sofaModuleProperties.isIgnoreModuleInstallFailure());
        return springContextInstallStage;
    }

    @Bean
    @ConditionalOnMissingBean
    public ModuleLogOutputStage moduleLogOutputStage(ApplicationRuntimeModel applicationRuntimeModel) {
        ModuleLogOutputStage moduleLogOutputStage = new ModuleLogOutputStage();
        moduleLogOutputStage.setApplicationRuntimeModel(applicationRuntimeModel);
        return moduleLogOutputStage;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextLoader sofaDynamicSpringContextLoader(SofaModuleProperties sofaModuleProperties, ApplicationContext applicationContext, ObjectProvider<ContextRefreshInterceptor> contextRefreshInterceptors, SofaPostProcessorShareManager sofaPostProcessorShareManager) {
        DynamicSpringContextLoader dynamicSpringContextLoader = new DynamicSpringContextLoader(applicationContext);
        dynamicSpringContextLoader.setActiveProfiles(sofaModuleProperties.getActiveProfiles());
        dynamicSpringContextLoader.setAllowBeanOverriding(sofaModuleProperties.isAllowBeanDefinitionOverriding());
        dynamicSpringContextLoader.setPublishEventToParent(sofaModuleProperties.isPublishEventToParent());
        dynamicSpringContextLoader.setContextRefreshInterceptors(new ArrayList(contextRefreshInterceptors.orderedStream().toList()));
        dynamicSpringContextLoader.setSofaPostProcessorShareManager(sofaPostProcessorShareManager);
        return dynamicSpringContextLoader;
    }

    @Bean(value={"sofaModuleRefreshExecutor"})
    @ConditionalOnMissingBean(name={"sofaModuleRefreshExecutor"})
    @ConditionalOnProperty(value={"sofa.boot.isle.moduleStartUpParallel"}, havingValue="true", matchIfMissing=true)
    public Supplier<ThreadPoolExecutor> sofaModuleRefreshExecutor(SofaModuleProperties sofaModuleProperties) {
        int coreSize = (int)((float)SofaBootConstants.CPU_CORE * sofaModuleProperties.getParallelRefreshPoolSizeFactor());
        long taskTimeout = sofaModuleProperties.getParallelRefreshTimeout();
        long checkPeriod = sofaModuleProperties.getParallelRefreshCheckPeriod();
        LOGGER.info("Create SOFA module refresh thread pool, corePoolSize: {}, maxPoolSize: {}, taskTimeout:{}, checkPeriod:{}", new Object[]{coreSize, coreSize, taskTimeout, checkPeriod});
        return () -> new SofaThreadPoolExecutor(coreSize, coreSize, 60L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue(1000), (ThreadFactory)new NamedThreadFactory("sofa-module-refresh"), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), "sofa-module-refresh", "sofa-boot", taskTimeout, checkPeriod, TimeUnit.SECONDS);
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaModuleProfileChecker sofaModuleProfileChecker(SofaModuleProperties sofaModuleProperties) {
        DefaultSofaModuleProfileChecker defaultSofaModuleProfileChecker = new DefaultSofaModuleProfileChecker();
        defaultSofaModuleProfileChecker.setUserCustomProfiles(sofaModuleProperties.getActiveProfiles());
        return defaultSofaModuleProfileChecker;
    }

    @Bean
    @ConditionalOnMissingBean
    public ModuleDeploymentValidator sofaModuleDeploymentValidator() {
        return new DefaultModuleDeploymentValidator();
    }

    @Bean
    @ConditionalOnMissingBean
    public SofaPostProcessorShareManager sofaModulePostProcessorShareManager(SofaModuleProperties sofaModuleProperties, ObjectProvider<SofaPostProcessorShareFilter> sofaPostProcessorShareFilters) {
        SofaPostProcessorShareManager sofaPostProcessorShareManager = new SofaPostProcessorShareManager();
        sofaPostProcessorShareManager.setShareParentContextPostProcessors(sofaModuleProperties.isShareParentPostProcessor());
        sofaPostProcessorShareManager.setSofaPostProcessorShareFilters(sofaPostProcessorShareFilters.orderedStream().toList());
        return sofaPostProcessorShareManager;
    }
}

