/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.runtime;

import com.alipay.sofa.boot.autoconfigure.condition.ConditionalOnSwitch;
import com.alipay.sofa.boot.autoconfigure.runtime.SofaRuntimeProperties;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.common.thread.NamedThreadFactory;
import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import com.alipay.sofa.runtime.api.client.ReferenceClient;
import com.alipay.sofa.runtime.api.client.ServiceClient;
import com.alipay.sofa.runtime.async.AsyncInitMethodManager;
import com.alipay.sofa.runtime.context.ComponentContextRefreshInterceptor;
import com.alipay.sofa.runtime.impl.ClientFactoryImpl;
import com.alipay.sofa.runtime.impl.StandardSofaRuntimeManager;
import com.alipay.sofa.runtime.proxy.ProxyBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.service.client.ReferenceClientImpl;
import com.alipay.sofa.runtime.service.client.ServiceClientImpl;
import com.alipay.sofa.runtime.service.impl.BindingAdapterFactoryImpl;
import com.alipay.sofa.runtime.service.impl.BindingConverterFactoryImpl;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spi.service.DynamicServiceProxyManager;
import com.alipay.sofa.runtime.spring.AsyncInitBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.spring.AsyncProxyBeanPostProcessor;
import com.alipay.sofa.runtime.spring.RuntimeContextBeanFactoryPostProcessor;
import com.alipay.sofa.runtime.spring.ServiceBeanFactoryPostProcessor;
import java.util.HashSet;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnClass(value={SofaRuntimeContext.class})
@EnableConfigurationProperties(value={SofaRuntimeProperties.class})
public class SofaRuntimeAutoConfiguration {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(SofaRuntimeAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public static SofaRuntimeManager sofaRuntimeManager(Environment environment, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory, ObjectProvider<DynamicServiceProxyManager> dynamicServiceProxyManager) {
        ClientFactoryImpl clientFactoryInternal = new ClientFactoryImpl();
        StandardSofaRuntimeManager sofaRuntimeManager = new StandardSofaRuntimeManager(environment.getProperty("spring.application.name"), Thread.currentThread().getContextClassLoader(), (ClientFactoryInternal)clientFactoryInternal);
        clientFactoryInternal.registerClient(ReferenceClient.class, (Object)new ReferenceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        clientFactoryInternal.registerClient(ServiceClient.class, (Object)new ServiceClientImpl(sofaRuntimeManager.getSofaRuntimeContext(), bindingConverterFactory, bindingAdapterFactory));
        SofaRuntimeContext sofaRuntimeContext = sofaRuntimeManager.getSofaRuntimeContext();
        dynamicServiceProxyManager.ifUnique(arg_0 -> ((SofaRuntimeContext)sofaRuntimeContext).setServiceProxyManager(arg_0));
        Binder binder = Binder.get((Environment)environment);
        SofaRuntimeContext.Properties properties = sofaRuntimeContext.getProperties();
        Bindable bindable = Bindable.of(SofaRuntimeContext.Properties.class).withExistingValue((Object)properties);
        binder.bind("sofa.boot.runtime", bindable);
        return sofaRuntimeManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public static SofaRuntimeContext sofaRuntimeContext(SofaRuntimeManager sofaRuntimeManager) {
        return sofaRuntimeManager.getSofaRuntimeContext();
    }

    @Bean
    @ConditionalOnMissingBean
    public static BindingConverterFactory bindingConverterFactory() {
        BindingConverterFactoryImpl bindingConverterFactory = new BindingConverterFactoryImpl();
        bindingConverterFactory.addBindingConverters(new HashSet(SpringFactoriesLoader.loadFactories(BindingConverter.class, null)));
        return bindingConverterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public static BindingAdapterFactory bindingAdapterFactory() {
        BindingAdapterFactoryImpl bindingAdapterFactory = new BindingAdapterFactoryImpl();
        bindingAdapterFactory.addBindingAdapters(new HashSet(SpringFactoriesLoader.loadFactories(BindingAdapter.class, null)));
        return bindingAdapterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public static RuntimeContextBeanFactoryPostProcessor runtimeContextBeanFactoryPostProcessor() {
        return new RuntimeContextBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public static ServiceBeanFactoryPostProcessor serviceBeanFactoryPostProcessor() {
        return new ServiceBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public static ProxyBeanFactoryPostProcessor proxyBeanFactoryPostProcessor() {
        return new ProxyBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ComponentContextRefreshInterceptor componentContextRefreshInterceptor(SofaRuntimeManager sofaRuntimeManager) {
        return new ComponentContextRefreshInterceptor(sofaRuntimeManager);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSwitch(value="runtimeAsyncInit")
    static class AsyncInitConfiguration {
        AsyncInitConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public static AsyncInitMethodManager asyncInitMethodManager() {
            return new AsyncInitMethodManager();
        }

        @Bean(value={"async-init-method-executor"})
        @ConditionalOnMissingBean(name={"async-init-method-executor"})
        public Supplier<ThreadPoolExecutor> asyncInitMethodExecutor(SofaRuntimeProperties sofaRuntimeProperties) {
            return () -> {
                int coreSize = sofaRuntimeProperties.getAsyncInitExecutorCoreSize();
                int maxSize = sofaRuntimeProperties.getAsyncInitExecutorMaxSize();
                Assert.isTrue((coreSize >= 0 ? 1 : 0) != 0, (String)"executorCoreSize must no less than zero");
                Assert.isTrue((maxSize >= 0 ? 1 : 0) != 0, (String)"executorMaxSize must no less than zero");
                LOGGER.info("create async-init-bean thread pool, corePoolSize: {}, maxPoolSize: {}.", (Object)coreSize, (Object)maxSize);
                return new SofaThreadPoolExecutor(coreSize, maxSize, 30L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new NamedThreadFactory("async-init-bean"), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), "async-init-bean", "sofa-boot");
            };
        }

        @Bean
        @ConditionalOnMissingBean
        public static AsyncProxyBeanPostProcessor asyncProxyBeanPostProcessor(AsyncInitMethodManager asyncInitMethodManager) {
            return new AsyncProxyBeanPostProcessor(asyncInitMethodManager);
        }

        @Bean
        @ConditionalOnMissingBean
        public static AsyncInitBeanFactoryPostProcessor asyncInitBeanFactoryPostProcessor() {
            return new AsyncInitBeanFactoryPostProcessor();
        }
    }
}

