/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer;

import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerProperties;
import com.alipay.sofa.boot.util.SofaBootEnvUtils;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SofaTracerConfigurationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (SofaBootEnvUtils.isSpringCloudBootstrapEnvironment((Environment)event.getEnvironment())) {
            return;
        }
        ConfigurableEnvironment environment = event.getEnvironment();
        String applicationName = environment.getProperty("spring.application.name");
        Assert.isTrue((boolean)StringUtils.hasText((String)applicationName), (String)"spring.application.name must be configured!");
        SofaTracerConfiguration.setProperty((String)"spring.application.name", (String)applicationName);
        Binder binder = Binder.get((Environment)environment);
        SofaTracerProperties sofaTracerProperties = new SofaTracerProperties();
        Bindable bindable = Bindable.of(SofaTracerProperties.class).withExistingValue((Object)sofaTracerProperties);
        binder.bind("sofa.boot.tracer", bindable);
        SofaTracerConfiguration.setProperty((String)"disable_middleware_digest_log", (String)sofaTracerProperties.getDisableDigestLog());
        SofaTracerConfiguration.setProperty((String)"disable_digest_log", sofaTracerProperties.getDisableConfiguration());
        SofaTracerConfiguration.setProperty((String)"tracer_global_rolling_policy", (String)sofaTracerProperties.getTracerGlobalRollingPolicy());
        SofaTracerConfiguration.setProperty((String)"tracer_global_log_reserve_day", (String)sofaTracerProperties.getTracerGlobalLogReserveDay());
        SofaTracerConfiguration.setProperty((String)"stat_log_interval", (String)sofaTracerProperties.getStatLogInterval());
        SofaTracerConfiguration.setProperty((String)"tracer_penetrate_attribute_max_length", (String)sofaTracerProperties.getBaggageMaxLength());
        SofaTracerConfiguration.setProperty((String)"tracer_system_penetrate_attribute_max_length", (String)sofaTracerProperties.getBaggageMaxLength());
        if (sofaTracerProperties.getSamplerName() != null) {
            SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_name_key", (String)sofaTracerProperties.getSamplerName());
        }
        if (StringUtils.hasText((String)sofaTracerProperties.getSamplerCustomRuleClassName())) {
            SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_custom_rule_class_name", (String)sofaTracerProperties.getSamplerCustomRuleClassName());
        }
        SofaTracerConfiguration.setProperty((String)"tracer_sampler_strategy_percentage_key", (String)String.valueOf(sofaTracerProperties.getSamplerPercentage()));
        SofaTracerConfiguration.setProperty((String)"global_json_format_output", (String)String.valueOf(sofaTracerProperties.isJsonOutput()));
    }

    public int getOrder() {
        return -2147483598;
    }
}

