/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.rabbitmq;

import com.alipay.sofa.boot.tracer.rabbitmq.RabbitMqBeanPostProcessor;
import com.sofa.alipay.tracer.plugins.rabbitmq.aspect.SofaTracerSendMessageAspect;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@AutoConfiguration(after={RabbitAutoConfiguration.class})
@ConditionalOnClass(value={Message.class, RabbitTemplate.class, SofaTracerSendMessageAspect.class, RabbitMqBeanPostProcessor.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.rabbitmq.enabled"}, havingValue="true", matchIfMissing=true)
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class RabbitMqAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={RabbitTemplate.class})
    public SofaTracerSendMessageAspect rabbitMqSendTracingAspect(RabbitTemplate rabbitTemplate) {
        return new SofaTracerSendMessageAspect(rabbitTemplate.getExchange(), rabbitTemplate.getRoutingKey(), rabbitTemplate.getMessageConverter(), rabbitTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public static RabbitMqBeanPostProcessor sofaTracerRabbitMqBeanPostProcessor() {
        return new RabbitMqBeanPostProcessor();
    }
}

