/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.redis;

import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerAutoConfiguration;
import com.sofa.alipay.tracer.plugins.spring.redis.SofaTracerRCFBeanPostProcessor;
import com.sofa.alipay.tracer.plugins.spring.redis.common.RedisActionWrapperHelper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@AutoConfiguration(after={SofaTracerAutoConfiguration.class})
@ConditionalOnClass(value={RedisConnectionFactory.class, RedisActionWrapperHelper.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.redis.enabled"}, havingValue="true", matchIfMissing=true)
public class RedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RedisActionWrapperHelper redisActionWrapperHelper() {
        return new RedisActionWrapperHelper();
    }

    @Bean
    @ConditionalOnMissingBean
    public static SofaTracerRCFBeanPostProcessor sofaTracerRCFBeanPostProcessor(RedisActionWrapperHelper redisActionWrapperHelper) {
        return new SofaTracerRCFBeanPostProcessor(redisActionWrapperHelper);
    }
}

