/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer.rocketmq;

import com.alipay.sofa.boot.tracer.rocketmq.RocketMqConsumerPostProcessor;
import com.alipay.sofa.boot.tracer.rocketmq.RocketMqProducerPostProcessor;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={RocketMQAutoConfiguration.class})
@ConditionalOnClass(value={MQProducer.class, RocketMQListenerContainer.class, RocketMqProducerPostProcessor.class})
@ConditionalOnProperty(name={"sofa.boot.tracer.rocketmq.enabled"}, havingValue="true", matchIfMissing=true)
public class RocketMqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static RocketMqProducerPostProcessor sofaTracerRocketMqProducerPostProcessor(Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        RocketMqProducerPostProcessor rocketMqProducerPostProcessor = new RocketMqProducerPostProcessor();
        rocketMqProducerPostProcessor.setAppName(appName);
        return rocketMqProducerPostProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    public static RocketMqConsumerPostProcessor sofaTracerRocketMqConsumerPostProcessor(Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        RocketMqConsumerPostProcessor rocketMqConsumerPostProcessor = new RocketMqConsumerPostProcessor();
        rocketMqConsumerPostProcessor.setAppName(appName);
        return rocketMqConsumerPostProcessor;
    }
}

