/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ExcludeRouter;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.Router;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RouterChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterChain.class);
    private static final Map<String, ExtensionClass<Router>> PROVIDER_AUTO_ACTIVES = Collections.synchronizedMap(new ConcurrentHashMap());
    private static final Map<String, ExtensionClass<Router>> CONSUMER_AUTO_ACTIVES = Collections.synchronizedMap(new ConcurrentHashMap());
    private static final ExtensionLoader<Router> EXTENSION_LOADER = RouterChain.buildLoader();
    private final List<Router> routers = new LinkedList<Router>();

    private static ExtensionLoader<Router> buildLoader() {
        ExtensionLoader<Router> extensionLoader = ExtensionLoaderFactory.getExtensionLoader(Router.class);
        extensionLoader.addListener(new ExtensionLoaderListener<Router>(){

            @Override
            public void onLoad(ExtensionClass<Router> extensionClass) {
                Class<Router> implClass = extensionClass.getClazz();
                AutoActive autoActive = implClass.getAnnotation(AutoActive.class);
                if (autoActive != null) {
                    String alias = extensionClass.getAlias();
                    if (autoActive.providerSide()) {
                        PROVIDER_AUTO_ACTIVES.put(alias, extensionClass);
                    }
                    if (autoActive.consumerSide()) {
                        CONSUMER_AUTO_ACTIVES.put(alias, extensionClass);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extension of interface " + Router.class + ", " + implClass + "(" + alias + ") will auto active");
                    }
                }
            }
        });
        return extensionLoader;
    }

    public RouterChain(List<Router> actualRouters, ConsumerBootstrap consumerBootstrap) {
        if (CommonUtils.isNotEmpty(actualRouters)) {
            for (Router router : actualRouters) {
                if (!router.needToLoad(consumerBootstrap)) continue;
                router.init(consumerBootstrap);
                this.routers.add(router);
            }
        }
    }

    public List<ProviderInfo> route(SofaRequest request, List<ProviderInfo> providerInfos) {
        for (Router router : this.routers) {
            providerInfos = router.route(request, providerInfos);
        }
        return providerInfos;
    }

    public static RouterChain buildConsumerChain(ConsumerBootstrap consumerBootstrap) {
        ConsumerConfig consumerConfig = consumerBootstrap.getConsumerConfig();
        ArrayList<Router> customRouters = consumerConfig.getRouterRef() == null ? new ArrayList() : new CopyOnWriteArrayList<Router>(consumerConfig.getRouterRef());
        HashSet<String> excludes = RouterChain.parseExcludeRouter(customRouters);
        ArrayList<ExtensionClass> extensionRouters = new ArrayList<ExtensionClass>();
        List<String> routerAliases = consumerConfig.getRouter();
        if (CommonUtils.isNotEmpty(routerAliases)) {
            for (String string : routerAliases) {
                if (RouterChain.startsWithExcludePrefix(string)) {
                    excludes.add(string.substring(1));
                    continue;
                }
                ExtensionClass extensionRouter = EXTENSION_LOADER.getExtensionClass(string);
                if (extensionRouter == null) continue;
                extensionRouters.add(extensionRouter);
            }
        }
        if (!excludes.contains("*") && !excludes.contains("default")) {
            for (Map.Entry entry : CONSUMER_AUTO_ACTIVES.entrySet()) {
                if (excludes.contains(entry.getKey())) continue;
                extensionRouters.add((ExtensionClass)entry.getValue());
            }
        }
        excludes = null;
        if (extensionRouters.size() > 1) {
            extensionRouters.sort(Comparator.comparingInt(ExtensionClass::getOrder));
        }
        ArrayList<Router> actualRouters = new ArrayList<Router>();
        for (ExtensionClass extensionRouter : extensionRouters) {
            Router actualRoute = (Router)extensionRouter.getExtInstance();
            actualRouters.add(actualRoute);
        }
        actualRouters.addAll(customRouters);
        return new RouterChain(actualRouters, consumerBootstrap);
    }

    private static HashSet<String> parseExcludeRouter(List<Router> customRouters) {
        HashSet<String> excludeKeys = new HashSet<String>();
        if (CommonUtils.isNotEmpty(customRouters)) {
            for (Router router : customRouters) {
                if (!(router instanceof ExcludeRouter)) continue;
                ExcludeRouter excludeRouter = (ExcludeRouter)router;
                String excludeName = excludeRouter.getExcludeName();
                if (StringUtils.isNotEmpty(excludeName)) {
                    String excludeRouterName;
                    String string = excludeRouterName = RouterChain.startsWithExcludePrefix(excludeName) ? excludeName.substring(1) : excludeName;
                    if (StringUtils.isNotEmpty(excludeRouterName)) {
                        excludeKeys.add(excludeRouterName);
                    }
                }
                customRouters.remove(router);
            }
        }
        if (!excludeKeys.isEmpty() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Find exclude routers: {}", excludeKeys);
        }
        return excludeKeys;
    }

    private static boolean startsWithExcludePrefix(String excludeName) {
        char c = excludeName.charAt(0);
        return c == '-' || c == '!';
    }
}

