/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.client.aft.ProviderInfoWeightManager;
import com.alipay.sofa.rpc.client.aft.impl.LogPrintDegradeStrategy;
import com.alipay.sofa.rpc.common.utils.CalculateUtils;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;

@Extension(value="weight")
public class WeightDegradeStrategy
extends LogPrintDegradeStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightDegradeStrategy.class);

    @Override
    public void degrade(MeasureResultDetail measureResultDetail) {
        super.degrade(measureResultDetail);
        if (measureResultDetail.isLogOnly()) {
            return;
        }
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        String appName = statDimension.getAppName();
        ProviderInfo providerInfo = statDimension.getProviderInfo();
        if (providerInfo == null || providerInfo.getStatus() == ProviderStatus.WARMING_UP) {
            return;
        }
        int currentWeight = ProviderInfoWeightManager.getWeight(providerInfo);
        double weightDegradeRate = FaultToleranceConfigManager.getWeightDegradeRate(appName);
        int degradeLeastWeight = FaultToleranceConfigManager.getDegradeLeastWeight(appName);
        int degradeWeight = CalculateUtils.multiply(currentWeight, weightDegradeRate);
        degradeWeight = degradeWeight < degradeLeastWeight ? degradeLeastWeight : degradeWeight;
        boolean success = ProviderInfoWeightManager.degradeWeight(providerInfo, degradeWeight);
        if (success && LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, "the weight was degraded. serviceUniqueName:[" + statDimension.getService() + "],ip:[" + statDimension.getIp() + "],origin weight:[" + currentWeight + "],degraded weight:[" + degradeWeight + "].");
        }
    }
}

