/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.triple;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.ClassLoaderUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.constant.TripleConstant;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.filter.FilterChain;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.message.triple.TripleResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import com.alipay.sofa.rpc.transport.triple.TripleInvoker;
import com.alipay.sofa.rpc.utils.SofaProtoUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import triple.Request;
import triple.Response;

public class TripleClientInvoker
implements TripleInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleClientInvoker.class);
    private static final String DEFAULT_SERIALIZATION = "hessian2";
    protected Channel channel;
    protected ConsumerConfig consumerConfig;
    protected ProviderInfo providerInfo;
    protected Method sofaStub;
    protected boolean useGeneric;
    private Serializer serializer;
    private String serialization;
    private Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();

    public TripleClientInvoker(ConsumerConfig consumerConfig, ProviderInfo providerInfo, Channel channel) {
        this.channel = channel;
        this.consumerConfig = consumerConfig;
        this.providerInfo = providerInfo;
        this.useGeneric = SofaProtoUtils.checkIfUseGeneric(consumerConfig);
        this.cacheCommonData(consumerConfig);
        if (!this.useGeneric) {
            Class<?> enclosingClass = consumerConfig.getProxyClass().getEnclosingClass();
            try {
                this.sofaStub = enclosingClass.getDeclaredMethod("getSofaStub", Channel.class, CallOptions.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("getSofaStub not found in enclosingClass" + enclosingClass.getName());
            }
        }
    }

    private void cacheCommonData(ConsumerConfig consumerConfig) {
        String serialization = consumerConfig.getSerialization();
        if (StringUtils.isBlank(serialization)) {
            serialization = this.getDefaultSerialization();
        }
        this.serialization = serialization;
        this.serializer = SerializerFactory.getSerializer(serialization);
    }

    protected String getDefaultSerialization() {
        return DEFAULT_SERIALIZATION;
    }

    @Override
    public SofaResponse invoke(SofaRequest sofaRequest, int timeout) throws Exception {
        if (!this.useGeneric) {
            SofaResponse sofaResponse = new SofaResponse();
            Object stub = this.sofaStub.invoke(null, this.channel, this.buildCustomCallOptions(sofaRequest, timeout), timeout);
            Method method = sofaRequest.getMethod();
            Object appResponse = method.invoke(stub, sofaRequest.getMethodArgs()[0]);
            sofaResponse.setAppResponse(appResponse);
            return sofaResponse;
        }
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(sofaRequest);
        Request request = TripleClientInvoker.getRequest(sofaRequest, this.serialization, this.serializer);
        Response response = (Response)ClientCalls.blockingUnaryCall((Channel)this.channel, (MethodDescriptor)methodDescriptor, (CallOptions)this.buildCustomCallOptions(sofaRequest, timeout), (Object)request);
        SofaResponse sofaResponse = new SofaResponse();
        byte[] responseDate = response.getData().toByteArray();
        Class<?> returnType = sofaRequest.getMethod().getReturnType();
        if (returnType != Void.TYPE && responseDate != null && responseDate.length > 0) {
            Serializer responseSerializer = SerializerFactory.getSerializer(response.getSerializeType());
            Object appResponse = responseSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseDate), returnType, null);
            sofaResponse.setAppResponse(appResponse);
        }
        return sofaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseFuture asyncInvoke(final SofaRequest sofaRequest, int timeout) throws Exception {
        final SofaResponseCallback sofaResponseCallback = sofaRequest.getSofaResponseCallback();
        final TripleResponseFuture future = new TripleResponseFuture(sofaRequest, timeout);
        final ClassLoader currentClassLoader = ClassLoaderUtils.getCurrentClassLoader();
        final RpcInternalContext context = RpcInternalContext.getContext();
        if (!this.useGeneric) {
            Method m = this.methodMap.get(sofaRequest.getMethodName());
            if (m == null) {
                TripleClientInvoker tripleClientInvoker = this;
                synchronized (tripleClientInvoker) {
                    m = this.methodMap.get(sofaRequest.getMethodName());
                    if (m == null) {
                        Method[] declaredMethods;
                        Class<?> clazz = Class.forName(sofaRequest.getInterfaceName());
                        for (Method tempM : declaredMethods = clazz.getDeclaredMethods()) {
                            if (!StringUtils.equals(tempM.getName(), sofaRequest.getMethodName()) || tempM.getParameterCount() != 2 || !StringUtils.equals(tempM.getParameterTypes()[1].getCanonicalName(), StreamObserver.class.getCanonicalName())) continue;
                            m = tempM;
                            this.methodMap.put(sofaRequest.getMethodName(), m);
                            break;
                        }
                    }
                }
            }
            Object stub = this.sofaStub.invoke(null, this.channel, this.buildCustomCallOptions(sofaRequest, timeout), null, this.consumerConfig, timeout);
            m.invoke(stub, sofaRequest.getMethodArgs()[0], new StreamObserver<Object>(){

                public void onNext(Object o) {
                    TripleClientInvoker.this.processSuccess(false, context, sofaRequest, o, sofaResponseCallback, future, currentClassLoader);
                }

                public void onError(Throwable throwable) {
                    TripleClientInvoker.this.processError(context, sofaRequest, throwable, sofaResponseCallback, future, currentClassLoader);
                }

                public void onCompleted() {
                }
            });
        } else {
            MethodDescriptor methodDescriptor = this.getMethodDescriptor(sofaRequest);
            Request request = TripleClientInvoker.getRequest(sofaRequest, this.serialization, this.serializer);
            ClientCalls.asyncUnaryCall((ClientCall)this.channel.newCall(methodDescriptor, this.buildCustomCallOptions(sofaRequest, timeout)), (Object)request, (StreamObserver)new StreamObserver<Object>(){

                public void onNext(Object o) {
                    TripleClientInvoker.this.processSuccess(true, context, sofaRequest, o, sofaResponseCallback, future, currentClassLoader);
                }

                public void onError(Throwable throwable) {
                    TripleClientInvoker.this.processError(context, sofaRequest, throwable, sofaResponseCallback, future, currentClassLoader);
                }

                public void onCompleted() {
                }
            });
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuccess(boolean needDecode, RpcInternalContext context, SofaRequest sofaRequest, Object o, SofaResponseCallback sofaResponseCallback, TripleResponseFuture future, ClassLoader classLoader) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            RpcInternalContext.setContext(context);
            SofaResponse sofaResponse = new SofaResponse();
            sofaResponse.setAppResponse(o);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, sofaRequest, sofaResponse, null));
            }
            this.pickupBaggage(context, sofaResponse);
            FilterChain chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain();
            if (chain != null) {
                chain.onAsyncResponse(this.consumerConfig, sofaRequest, sofaResponse, null);
            }
            this.recordClientElapseTime(context);
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(sofaRequest, sofaResponse, null));
            }
            Object appResponse = o;
            if (needDecode) {
                Response response = (Response)o;
                byte[] responseDate = response.getData().toByteArray();
                Class<?> returnType = sofaRequest.getMethod().getReturnType();
                if (returnType != Void.TYPE && responseDate != null && responseDate.length > 0) {
                    Serializer responseSerializer = SerializerFactory.getSerializer(response.getSerializeType());
                    appResponse = responseSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseDate), returnType, null);
                }
            }
            if (sofaResponseCallback != null) {
                sofaResponseCallback.onAppResponse(appResponse, sofaRequest.getMethodName(), sofaRequest);
            } else {
                future.setSuccess(appResponse);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processError(RpcInternalContext context, SofaRequest sofaRequest, Throwable throwable, SofaResponseCallback sofaResponseCallback, TripleResponseFuture future, ClassLoader classLoader) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            FilterChain chain;
            Thread.currentThread().setContextClassLoader(classLoader);
            RpcInternalContext.setContext(context);
            if (EventBus.isEnable(ClientAsyncReceiveEvent.class)) {
                EventBus.post(new ClientAsyncReceiveEvent(this.consumerConfig, this.providerInfo, sofaRequest, null, throwable));
            }
            if ((chain = this.consumerConfig.getConsumerBootstrap().getCluster().getFilterChain()) != null) {
                chain.onAsyncResponse(this.consumerConfig, sofaRequest, null, throwable);
            }
            this.recordClientElapseTime(context);
            if (EventBus.isEnable(ClientEndInvokeEvent.class)) {
                EventBus.post(new ClientEndInvokeEvent(sofaRequest, null, throwable));
            }
            if (sofaResponseCallback != null) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (status.getCode() == Status.Code.UNKNOWN) {
                    sofaResponseCallback.onAppException(throwable, sofaRequest.getMethodName(), sofaRequest);
                } else {
                    sofaResponseCallback.onSofaException(new SofaRpcException(0, status.getCause()), sofaRequest.getMethodName(), sofaRequest);
                }
            } else {
                future.setFailure(throwable);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
            RpcInvokeContext.removeContext();
            RpcInternalContext.removeAllContext();
        }
    }

    protected void recordClientElapseTime(RpcInternalContext context) {
        Long startTime;
        if (context != null && (startTime = (Long)context.removeAttachment("_client_send_time")) != null) {
            context.setAttachment("_client_elapse", RpcRuntimeContext.now() - startTime);
        }
    }

    protected void pickupBaggage(RpcInternalContext context, SofaResponse response) {
        if (RpcInvokeContext.isBaggageEnable()) {
            RpcInvokeContext old = null;
            RpcInvokeContext newContext = null;
            if (context != null) {
                old = (RpcInvokeContext)context.getAttachment(".invoke_ctx");
            }
            if (old != null) {
                RpcInvokeContext.setContext(old);
            }
            newContext = RpcInvokeContext.getContext();
            BaggageResolver.pickupFromResponse(newContext, response);
            if (old != null) {
                old.getAllResponseBaggage().putAll(newContext.getAllResponseBaggage());
                old.getAllRequestBaggage().putAll(newContext.getAllRequestBaggage());
            }
        }
    }

    private MethodDescriptor getMethodDescriptor(SofaRequest sofaRequest) {
        String serviceName = sofaRequest.getInterfaceName();
        String methodName = sofaRequest.getMethodName();
        MethodDescriptor.Marshaller requestMarshaller = ProtoUtils.marshaller((Message)Request.getDefaultInstance());
        MethodDescriptor.Marshaller responseMarshaller = ProtoUtils.marshaller((Message)Response.getDefaultInstance());
        String fullMethodName = MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName);
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(fullMethodName).setSampledToLocalTracing(true).setRequestMarshaller(requestMarshaller).setResponseMarshaller(responseMarshaller).build();
        return methodDescriptor;
    }

    public static Request getRequest(SofaRequest sofaRequest, String serialization, Serializer serializer) {
        Request.Builder builder = Request.newBuilder();
        builder.setSerializeType(serialization);
        String[] methodArgSigs = sofaRequest.getMethodArgSigs();
        Object[] methodArgs = sofaRequest.getMethodArgs();
        for (int i = 0; i < methodArgSigs.length; ++i) {
            Object arg = methodArgs[i];
            ByteString argByteString = ByteString.copyFrom((byte[])serializer.encode(arg, null).array());
            builder.addArgs(argByteString);
            builder.addArgTypes(methodArgSigs[i]);
        }
        return builder.build();
    }

    protected CallOptions buildCustomCallOptions(SofaRequest sofaRequest, int timeout) {
        CallOptions tripleCallOptions = CallOptions.DEFAULT;
        String target = this.consumerConfig.getParameter("interworking.target");
        if (StringUtils.isNotBlank(target)) {
            tripleCallOptions = tripleCallOptions.withAuthority(target);
        }
        if (timeout >= 0) {
            tripleCallOptions = tripleCallOptions.withDeadlineAfter((long)timeout, TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotBlank(this.consumerConfig.getUniqueId())) {
            tripleCallOptions = tripleCallOptions.withOption(TripleConstant.UNIQUE_ID, (Object)this.consumerConfig.getUniqueId());
        }
        return tripleCallOptions;
    }
}

