/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.bolt;

import com.alipay.remoting.DefaultCustomSerializer;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcProtocol;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.codec.bolt.SimpleMapSerializer;
import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.request.RequestBase;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import java.util.HashMap;
import java.util.Map;

public class SofaRpcSerialization
extends DefaultCustomSerializer {
    private final boolean meshSwitch = SofaConfigs.getBooleanValue("rpc_mesh_switch", false);
    protected SimpleMapSerializer mapSerializer;

    public SofaRpcSerialization() {
        this.init();
    }

    protected void init() {
        this.mapSerializer = new SimpleMapSerializer();
    }

    public <Response extends ResponseCommand> boolean serializeHeader(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            Object responseObject = ((RpcResponseCommand)response).getResponseObject();
            if (responseObject instanceof SofaResponse) {
                SofaResponse sofaResponse = (SofaResponse)responseObject;
                if (sofaResponse.isError() || sofaResponse.getAppResponse() instanceof Throwable) {
                    sofaResponse.addResponseProp("sofa_head_response_error", "true");
                }
                response.setHeader(this.mapSerializer.encode(sofaResponse.getResponseProps()));
            }
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeHeader(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object requestObject = requestCommand.getRequestObject();
            String service = this.getTargetServiceName(requestObject);
            if (StringUtils.isNotEmpty(service)) {
                HashMap<String, String> header = new HashMap<String, String>(16);
                header.put("service", service);
                byte serializer = requestCommand.getSerializer();
                if (serializer != 1 && serializer != 2) {
                    this.putRequestMetadataToHeader(requestObject, header);
                } else if (this.meshSwitch) {
                    this.putRequestMetadataToHeader(requestObject, header);
                }
                requestCommand.setHeader(this.mapSerializer.encode(header));
            }
            return true;
        }
        return false;
    }

    protected void putRequestMetadataToHeader(Object requestObject, Map<String, String> header) {
        if (requestObject instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)requestObject;
            header.put("sofa_head_method_name", requestBase.getMethodName());
            header.put("sofa_head_target_service", requestBase.getTargetServiceUniqueName());
            if (requestBase instanceof SofaRequest) {
                SofaRequest sofaRequest = (SofaRequest)requestBase;
                header.put("sofa_head_target_app", sofaRequest.getTargetAppName());
                Map<String, Object> requestProps = sofaRequest.getRequestProps();
                if (requestProps != null) {
                    CodecUtils.flatCopyTo("", requestProps, header);
                }
            }
        }
    }

    protected String getTargetServiceName(Object request) {
        if (request instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)request;
            return requestBase.getTargetServiceUniqueName();
        }
        return null;
    }

    public <Request extends RequestCommand> boolean deserializeHeader(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            if (requestCommand.getRequestHeader() != null) {
                return true;
            }
            byte[] header = requestCommand.getHeader();
            Map<String, String> headerMap = this.mapSerializer.decode(header);
            requestCommand.setRequestHeader(headerMap);
            return true;
        }
        return false;
    }

    public <Response extends ResponseCommand> boolean deserializeHeader(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte[] header = responseCommand.getHeader();
            responseCommand.setResponseHeader(this.mapSerializer.decode(header));
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeContent(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object requestObject = requestCommand.getRequestObject();
            byte serializerCode = requestCommand.getSerializer();
            try {
                HashMap<String, String> header = (HashMap<String, String>)requestCommand.getRequestHeader();
                if (header == null) {
                    header = new HashMap<String, String>();
                }
                this.putKV(header, "sofa_head_generic_type", (String)invokeContext.get("sofa_head_generic_type"));
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializerCode);
                AbstractByteBuf byteBuf = rpcSerializer.encode(requestObject, header);
                request.setContent(byteBuf.array());
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new SerializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordSerializeRequest((RequestCommand)requestCommand, invokeContext);
            }
        }
        return false;
    }

    protected void recordSerializeRequest(RequestCommand requestCommand, InvokeContext invokeContext) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_ser_time", cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends RequestCommand> boolean deserializeContent(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object header = requestCommand.getRequestHeader();
            if (!(header instanceof Map)) {
                throw new DeserializationException("Head of request is null or is not map");
            }
            Map headerMap = (Map)header;
            byte[] content = requestCommand.getContent();
            if (content == null || content.length == 0) {
                throw new DeserializationException("Content of request is null");
            }
            try {
                String service = (String)headerMap.get("service");
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader serviceClassLoader = ReflectCache.getServiceClassLoader(service);
                try {
                    Thread.currentThread().setContextClassLoader(serviceClassLoader);
                    Serializer rpcSerializer = SerializerFactory.getSerializer(requestCommand.getSerializer());
                    Object sofaRequest = ClassUtils.forName(requestCommand.getRequestClass()).newInstance();
                    rpcSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(requestCommand.getContent()), sofaRequest, (Map<String, String>)headerMap);
                    requestCommand.setRequestObject(sofaRequest);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new DeserializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordDeserializeRequest((RequestCommand)requestCommand);
            }
        }
        return false;
    }

    private void recordDeserializeRequest(RequestCommand requestCommand) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_des_time", cost);
    }

    public <Response extends ResponseCommand> boolean serializeContent(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializerCode = response.getSerializer();
            try {
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializerCode);
                AbstractByteBuf byteBuf = rpcSerializer.encode(responseCommand.getResponseObject(), null);
                responseCommand.setContent(byteBuf.array());
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new SerializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordSerializeResponse(responseCommand);
            }
        }
        return false;
    }

    private void recordSerializeResponse(RpcResponseCommand responseCommand) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_ser_time", cost);
    }

    public <Response extends ResponseCommand> boolean deserializeContent(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializer = response.getSerializer();
            byte[] content = responseCommand.getContent();
            if (content == null || content.length == 0) {
                return false;
            }
            try {
                Object sofaResponse = ClassUtils.forName(responseCommand.getResponseClass()).newInstance();
                HashMap<String, String> header = (HashMap<String, String>)responseCommand.getResponseHeader();
                if (header == null) {
                    header = new HashMap<String, String>();
                }
                this.putKV(header, "sofa_head_target_service", (String)invokeContext.get("sofa_head_target_service"));
                this.putKV(header, "sofa_head_method_name", (String)invokeContext.get("sofa_head_method_name"));
                this.putKV(header, "sofa_head_generic_type", (String)invokeContext.get("sofa_head_generic_type"));
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializer);
                rpcSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseCommand.getContent()), sofaResponse, header);
                responseCommand.setResponseObject(sofaResponse);
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new DeserializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordDeserializeResponse(responseCommand, invokeContext);
            }
        }
        return false;
    }

    protected void putKV(Map<String, String> map, String key, String value) {
        if (map != null && key != null && value != null) {
            map.put(key, value);
        }
    }

    private void recordDeserializeResponse(RpcResponseCommand responseCommand, InvokeContext invokeContext) {
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_des_time", cost);
    }
}

