/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.bolt;

import com.alipay.remoting.Connection;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class BoltClientConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltClientConnectionManager.class);
    final ConcurrentMap<ClientTransportConfig, Connection> urlConnectionMap = new ConcurrentHashMap<ClientTransportConfig, Connection>();
    final ConcurrentMap<Connection, AtomicInteger> connectionRefCounter = new ConcurrentHashMap<Connection, AtomicInteger>();

    protected BoltClientConnectionManager(boolean addHook) {
        if (addHook) {
            RpcRuntimeContext.registryDestroyHook(new Destroyable.DestroyHook(){

                @Override
                public void preDestroy() {
                }

                @Override
                public void postDestroy() {
                    BoltClientConnectionManager.this.checkLeak();
                }
            });
        }
    }

    protected void checkLeak() {
        if (CommonUtils.isNotEmpty(this.urlConnectionMap)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Bolt client transport maybe leak. {}", this.urlConnectionMap);
            }
            this.urlConnectionMap.clear();
        }
        if (CommonUtils.isNotEmpty(this.connectionRefCounter)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Bolt client transport maybe leak. {}", this.connectionRefCounter);
            }
            this.connectionRefCounter.clear();
        }
    }

    public Connection getConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        if (rpcClient == null || transportConfig == null || url == null) {
            return null;
        }
        Connection connection = (Connection)this.urlConnectionMap.get(transportConfig);
        if (connection != null && !connection.isFine()) {
            this.closeConnection(rpcClient, transportConfig, url);
            connection = null;
        }
        if (connection == null) {
            try {
                connection = rpcClient.getConnection(url, url.getConnectTimeout());
            }
            catch (InterruptedException e) {
                throw new SofaRpcRuntimeException(e);
            }
            catch (RemotingException e) {
                throw new SofaRpcRuntimeException(e);
            }
            if (connection == null) {
                return null;
            }
            Connection oldConnection = this.urlConnectionMap.putIfAbsent(transportConfig, connection);
            if (oldConnection != null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Multiple threads init ClientTransport with same key:" + url);
                }
                connection.close();
                connection = oldConnection;
            } else {
                AtomicInteger oldCounter;
                AtomicInteger counter = (AtomicInteger)this.connectionRefCounter.get(connection);
                if (counter == null && (oldCounter = this.connectionRefCounter.putIfAbsent(connection, counter = new AtomicInteger(0))) != null) {
                    counter = oldCounter;
                }
                int currentCount = counter.incrementAndGet();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Bolt client transport {} of {}, current ref count is: {}", url.toString(), NetUtils.channelToString(connection.getLocalAddress(), connection.getRemoteAddress()), currentCount);
                }
            }
        }
        return connection;
    }

    public void closeConnection(RpcClient rpcClient, ClientTransportConfig transportConfig, Url url) {
        boolean needDestroy;
        if (rpcClient == null || transportConfig == null || url == null) {
            return;
        }
        Connection connection = (Connection)this.urlConnectionMap.remove(transportConfig);
        if (connection == null) {
            return;
        }
        AtomicInteger integer = (AtomicInteger)this.connectionRefCounter.get(connection);
        if (integer == null) {
            needDestroy = true;
        } else {
            int currentCount = integer.decrementAndGet();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client transport {} of {} , current ref count is: {}", url.toString(), NetUtils.channelToString(connection.getLocalAddress(), connection.getRemoteAddress()), currentCount);
            }
            if (currentCount <= 0) {
                this.connectionRefCounter.remove(connection);
                needDestroy = true;
            } else {
                needDestroy = false;
            }
        }
        if (needDestroy) {
            rpcClient.closeConnection(url);
        }
    }
}

