/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mit.alitts;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public final class CommonUtils {
    private static final String TAG = "idst CommonUtils";

    public static synchronized boolean copyAssetsData(Context context) {
        List<String> list;
        String string2 = CommonUtils.getModelPath(context);
        return CommonUtils.copyList((AssetManager)(context = context.getApplicationContext().getAssets()), list = CommonUtils.getCopyList((AssetManager)context), string2);
    }

    public static String readContent(Context object, String string2) {
        try {
            int n2;
            object = object.getAssets().open(string2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = ((InputStream)object).read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            new StringBuilder("read asset file error , ").append(string2).append(" , ").append(exception.toString());
            return null;
        }
    }

    public static String getModelPath(Context context) {
        return context.getApplicationContext().getFilesDir().toString() + "/asr";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getCopyList(AssetManager object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            object = object.open("copylist.txt");
            object = new InputStreamReader((InputStream)object);
            bufferedReader = new BufferedReader((Reader)object);
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).trim().startsWith("#") || ((String)object).trim().isEmpty()) continue;
                arrayList.add((String)object);
            }
        }
        catch (IOException iOException) {
            if (bufferedReader == null) return arrayList;
            try {
                bufferedReader.close();
                return arrayList;
            }
            catch (IOException iOException2) {
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return arrayList;
        }
        catch (IOException iOException) {
            return arrayList;
        }
    }

    public static boolean copyList(AssetManager assetManager, List<String> object, String string2) {
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            CommonUtils.copyFileOrDir(assetManager, string3, string2 + "/" + string3);
        }
        return true;
    }

    private static boolean copyFileOrDir(AssetManager assetManager, String string2, String string3) {
        boolean bl2 = true;
        try {
            String[] stringArray = assetManager.list(string2);
            if (stringArray.length == 0) {
                bl2 = true & CommonUtils.copyAsset(assetManager, string2, string3);
            } else {
                File file = new File(string3);
                if (!file.exists()) {
                    file.mkdirs();
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    bl2 = CommonUtils.copyFileOrDir(assetManager, string2 + "/" + stringArray[i2], string3 + "/" + stringArray[i2]);
                    if (bl2) continue;
                    return bl2;
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private static boolean copyAsset(AssetManager assetManager, String string2, String string3) {
        OutputStream outputStream;
        InputStream inputStream;
        block20: {
            inputStream = null;
            outputStream = null;
            if (string2.length() > 0 && string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            new StringBuilder("copying asset files from [").append(string2).append("] to [").append(string3).append("]");
            inputStream = assetManager.open(string2);
            new File(string3).createNewFile();
            outputStream = new FileOutputStream(string3);
            CommonUtils.copyFile(inputStream, outputStream);
            outputStream.flush();
            if (inputStream == null) break block20;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                new StringBuilder().append(iOException);
            }
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception exception) {
            block21: {
                try {
                    new StringBuilder("Abort copying asset files from [").append(string2).append("] to [").append(string3).append("]");
                    if (inputStream == null) break block21;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            new StringBuilder().append(iOException);
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    new StringBuilder().append(iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static int clamp(int n2, int n3, int n4) {
        if (n2 < n4) {
            if (n2 > n3) {
                return n2;
            }
            return n3;
        }
        return n4;
    }

    public static int getVoiceVolume(short[] sArray) {
        short s2 = 0;
        short[] sArray2 = sArray;
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s3 = sArray2[i2];
            s3 = s3 < 0 ? -s3 : s3;
            if (s3 <= s2) continue;
            s2 = s3;
        }
        short s4 = (short)(s2 >> 7);
        s2 = s4;
        if (s4 > 100) {
            return 100;
        }
        return s2;
    }

    public static int[] bytesToInts(byte[] object) {
        IntBuffer intBuffer = ByteBuffer.wrap((byte[])object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        object = intBuffer;
        int[] nArray = new int[intBuffer.remaining()];
        ((IntBuffer)object).get(nArray);
        return nArray;
    }

    public static int getVoiceVolume(byte[] objectArray, int n2) {
        int[] nArray = CommonUtils.bytesToInts(objectArray);
        objectArray = nArray;
        int n3 = nArray.length / n2;
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != 1) {
                l2 += (long)(objectArray[i2 * n2 + 5] * objectArray[i2 * n2 + 5]);
                continue;
            }
            l2 += (long)(objectArray[i2 * n2] * objectArray[i2 * n2]);
        }
        return (int)(10.0 * Math.log10((double)l2 / ((double)n3 * 1.0)));
    }

    public static float clamp(float f2, float f3, float f4) {
        if (f2 < f4) {
            if (f2 > f3) {
                return f2;
            }
            return f3;
        }
        return f4;
    }

    private static boolean isFile(String string2) {
        return !string2.endsWith("/");
    }

    public static boolean shouldDebug() {
        String string2 = Environment.getExternalStorageDirectory().getPath() + "/AliSROpenDebugMode";
        return new File(string2).exists();
    }

    private static String[] getFileNames(Context context, String string2) {
        String[] stringArray = null;
        try {
            stringArray = context.getAssets().list(string2);
        }
        catch (IOException iOException) {}
        return stringArray;
    }
}

