/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.graphics.Color;
import com.amap.api.maps.AMapException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gradient {
    private static final int DEFAULT_COLOR_MAP_SIZE = 1000;
    private int mColorMapSize;
    private int[] mColors;
    private float[] mStartPoints;
    private boolean isAvailable = true;

    public Gradient(int[] nArray, float[] fArray) {
        this(nArray, fArray, 0);
    }

    private Gradient(int[] nArray, float[] fArray, byte by2) {
        try {
            if (nArray == null || fArray == null) {
                throw new AMapException("colors and startPoints should not be null");
            }
            if (nArray.length != fArray.length) {
                throw new AMapException("colors and startPoints should be same length");
            }
            if (nArray.length == 0) {
                throw new AMapException("No colors have been defined");
            }
            for (by2 = 1; by2 < fArray.length; by2 = (byte)(by2 + 1)) {
                if (!(fArray[by2] < fArray[by2 - 1])) continue;
                throw new AMapException("startPoints should be in increasing order");
            }
            this.mColorMapSize = 1000;
            this.mColors = new int[nArray.length];
            this.mStartPoints = new float[fArray.length];
            System.arraycopy(nArray, 0, this.mColors, 0, nArray.length);
            System.arraycopy(fArray, 0, this.mStartPoints, 0, fArray.length);
            this.isAvailable = true;
            return;
        }
        catch (AMapException aMapException) {
            this.isAvailable = false;
            aMapException.getErrorMessage();
            aMapException.printStackTrace();
            return;
        }
    }

    public int[] getColors() {
        return this.mColors;
    }

    public float[] getStartPoints() {
        return this.mStartPoints;
    }

    private HashMap<Integer, a> a() {
        int n2;
        HashMap<Integer, a> hashMap = new HashMap<Integer, a>(32);
        if (this.mStartPoints[0] != 0.0f) {
            n2 = Color.argb((int)0, (int)Color.red((int)this.mColors[0]), (int)Color.green((int)this.mColors[0]), (int)Color.blue((int)this.mColors[0]));
            hashMap.put(0, new a(n2, this.mColors[0], (float)this.mColorMapSize * this.mStartPoints[0], 0));
        }
        for (n2 = 1; n2 < this.mColors.length; ++n2) {
            hashMap.put((int)((float)this.mColorMapSize * this.mStartPoints[n2 - 1]), new a(this.mColors[n2 - 1], this.mColors[n2], (float)this.mColorMapSize * (this.mStartPoints[n2] - this.mStartPoints[n2 - 1]), 0));
        }
        if (this.mStartPoints[this.mStartPoints.length - 1] != 1.0f) {
            n2 = this.mStartPoints.length - 1;
            hashMap.put((int)((float)this.mColorMapSize * this.mStartPoints[n2]), new a(this.mColors[n2], this.mColors[n2], (float)this.mColorMapSize * (1.0f - this.mStartPoints[n2]), 0));
        }
        return hashMap;
    }

    protected int[] generateColorMap(double d2) {
        int n2;
        HashMap<Integer, a> hashMap = this.a();
        int[] nArray = new int[this.mColorMapSize];
        a a2 = hashMap.get(0);
        int n3 = 0;
        for (n2 = 0; n2 < this.mColorMapSize; ++n2) {
            if (hashMap.containsKey(n2)) {
                a2 = hashMap.get(n2);
                n3 = n2;
            }
            float f2 = (float)(n2 - n3) / a2.c;
            nArray[n2] = Gradient.a(a2.a, a2.b, f2);
        }
        if (d2 != 1.0) {
            for (n2 = 0; n2 < this.mColorMapSize; ++n2) {
                int n4 = nArray[n2];
                nArray[n2] = Color.argb((int)((int)((double)Color.alpha((int)n4) * d2)), (int)Color.red((int)n4), (int)Color.green((int)n4), (int)Color.blue((int)n4));
            }
        }
        return nArray;
    }

    private static int a(int n2, int n3, float f2) {
        int n4 = (int)((float)(Color.alpha((int)n3) - Color.alpha((int)n2)) * f2 + (float)Color.alpha((int)n2));
        float[] fArray = new float[3];
        Color.RGBToHSV((int)Color.red((int)n2), (int)Color.green((int)n2), (int)Color.blue((int)n2), (float[])fArray);
        float[] fArray2 = new float[3];
        Color.RGBToHSV((int)Color.red((int)n3), (int)Color.green((int)n3), (int)Color.blue((int)n3), (float[])fArray2);
        if (fArray[0] - fArray2[0] > 180.0f) {
            fArray2[0] = fArray2[0] + 360.0f;
        } else if (fArray2[0] - fArray[0] > 180.0f) {
            fArray[0] = fArray[0] + 360.0f;
        }
        float[] fArray3 = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray3[i2] = (fArray2[i2] - fArray[i2]) * f2 + fArray[i2];
        }
        return Color.HSVToColor((int)n4, (float[])fArray3);
    }

    protected boolean isAvailable() {
        return this.isAvailable;
    }

    private static final class a {
        private final int a;
        private final int b;
        private final float c;

        private a(int n2, int n3, float f2) {
            this.a = n2;
            this.b = n3;
            this.c = f2;
        }

        /* synthetic */ a(int n2, int n3, float f2, byte by2) {
            this(n2, n3, f2);
        }
    }
}

