/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.support.v4.util.LongSparseArray;
import com.amap.api.col.3n.cu;
import com.amap.api.maps.AMapException;
import com.amap.api.maps.model.Gradient;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Tile;
import com.amap.api.maps.model.TileProvider;
import com.amap.api.maps.model.WeightedLatLng;
import com.amap.api.maps.model.a;
import com.autonavi.amap.mapcore.DPoint;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatmapTileProvider
implements TileProvider {
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.rgb((int)102, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.2f, 1.0f};
    public static final Gradient DEFAULT_GRADIENT = new Gradient(DEFAULT_GRADIENT_COLORS, DEFAULT_GRADIENT_START_POINTS);
    private static final int TILE_DIM = 256;
    private static final int SCREEN_SIZE = 1280;
    private static final int DEFAULT_MIN_ZOOM = 5;
    private static final int DEFAULT_MAX_ZOOM = 11;
    private static final int MAX_ZOOM_LEVEL = 21;
    private static final int MIN_RADIUS = 10;
    private static final int MAX_RADIUS = 50;
    private a mTree;
    private Collection<WeightedLatLng> mData;
    private cu mBounds;
    private int mRadius;
    private Gradient mGradient;
    private int[] mColorMap;
    private double[] mKernel;
    private double mOpacity;
    private double[] mMaxIntensity;

    private HeatmapTileProvider(Builder builder) {
        this.mData = builder.data;
        this.mRadius = builder.radius;
        this.mGradient = builder.gradient;
        if (this.mGradient == null || !this.mGradient.isAvailable()) {
            this.mGradient = DEFAULT_GRADIENT;
        }
        this.mOpacity = builder.opacity;
        this.mKernel = HeatmapTileProvider.a(this.mRadius, (double)this.mRadius / 3.0);
        HeatmapTileProvider heatmapTileProvider = this;
        heatmapTileProvider.a(heatmapTileProvider.mGradient);
        HeatmapTileProvider heatmapTileProvider2 = this;
        heatmapTileProvider2.b(heatmapTileProvider2.mData);
    }

    private void b(Collection<WeightedLatLng> iterator) {
        try {
            ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                WeightedLatLng weightedLatLng;
                WeightedLatLng weightedLatLng2 = (WeightedLatLng)iterator.next();
                if (!(weightedLatLng.latLng.latitude < 85.0) || !(weightedLatLng2.latLng.latitude > -85.0)) continue;
                arrayList.add(weightedLatLng2);
            }
            this.mData = arrayList;
            this.mBounds = HeatmapTileProvider.d(this.mData);
            this.mTree = new a(this.mBounds);
            for (WeightedLatLng weightedLatLng2 : this.mData) {
                this.mTree.a(weightedLatLng2);
            }
            this.mMaxIntensity = this.a(this.mRadius);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> object) {
        ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
        object = object.iterator();
        while (object.hasNext()) {
            LatLng latLng = (LatLng)object.next();
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    @Override
    public Tile getTile(int n2, int n3, int n4) {
        int n5;
        double d2 = 1.0 / Math.pow(2.0, n4);
        double d3 = d2 * (double)this.mRadius / 256.0;
        double d4 = (d2 + 2.0 * d3) / (double)(256 + this.mRadius * 2);
        double d5 = (double)n2 * d2 - d3;
        double d6 = (double)(n2 + 1) * d2 + d3;
        double d7 = (double)n3 * d2 - d3;
        double d8 = (double)(n3 + 1) * d2 + d3;
        double d9 = 0.0;
        Collection<Object> collection = new ArrayList();
        if (d5 < 0.0) {
            cu cu2 = new cu(d5 + 1.0, 1.0, d7, d8);
            d9 = -1.0;
            collection = this.mTree.a(cu2);
        } else if (d6 > 1.0) {
            cu cu3 = new cu(0.0, d6 - 1.0, d7, d8);
            d9 = 1.0;
            collection = this.mTree.a(cu3);
        }
        Iterator<Object> iterator = new cu(d5, d6, d7, d8);
        Object object = new cu(this.mBounds.a - d3, this.mBounds.c + d3, this.mBounds.b - d3, this.mBounds.d + d3);
        if (!((cu)((Object)iterator)).a((cu)object)) {
            return TileProvider.NO_TILE;
        }
        if ((iterator = this.mTree.a((cu)((Object)iterator))).isEmpty()) {
            return TileProvider.NO_TILE;
        }
        object = new double[256 + this.mRadius * 2][256 + this.mRadius * 2];
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            WeightedLatLng weightedLatLng = (WeightedLatLng)iterator.next();
            DPoint dPoint = weightedLatLng.getPoint();
            n5 = (int)((dPoint.x - d5) / d4);
            int n6 = (int)((dPoint.y - d7) / d4);
            Object object2 = object[n5];
            int n7 = n6;
            object2[n7] = object2[n7] + weightedLatLng.intensity;
        }
        for (WeightedLatLng weightedLatLng : collection) {
            DPoint dPoint = weightedLatLng.getPoint();
            n5 = (int)((dPoint.x + d9 - d5) / d4);
            int n8 = (int)((dPoint.y - d7) / d4);
            Object object3 = object[n5];
            int n9 = n8;
            object3[n9] = object3[n9] + weightedLatLng.intensity;
        }
        return HeatmapTileProvider.a(HeatmapTileProvider.a(HeatmapTileProvider.a((double[][])object, this.mKernel), this.mColorMap, this.mMaxIntensity[n4]));
    }

    private void a(Gradient gradient) {
        this.mGradient = gradient;
        this.mColorMap = gradient.generateColorMap(this.mOpacity);
    }

    private double[] a(int n2) {
        int n3;
        double[] dArray = new double[21];
        for (n3 = 5; n3 < 11; ++n3) {
            dArray[n3] = HeatmapTileProvider.a(this.mData, this.mBounds, n2, (int)(1280.0 * Math.pow(2.0, n3)));
            if (n3 != 5) continue;
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray[i2] = dArray[n3];
            }
        }
        for (n3 = 11; n3 < 21; ++n3) {
            dArray[n3] = dArray[10];
        }
        return dArray;
    }

    private static Tile a(Bitmap object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        return Tile.obtain(256, 256, (byte[])object);
    }

    private static cu d(Collection<WeightedLatLng> object) {
        object = object.iterator();
        WeightedLatLng weightedLatLng = object.next();
        double d2 = weightedLatLng.getPoint().x;
        double d3 = weightedLatLng.getPoint().x;
        double d4 = weightedLatLng.getPoint().y;
        double d5 = weightedLatLng.getPoint().y;
        while (object.hasNext()) {
            weightedLatLng = (WeightedLatLng)object.next();
            double d6 = weightedLatLng.getPoint().x;
            double d7 = weightedLatLng.getPoint().y;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 < d4) {
                d4 = d7;
            }
            if (!(d7 > d5)) continue;
            d5 = d7;
        }
        return new cu(d2, d3, d4, d5);
    }

    private static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -n2; i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (2.0 * d2 * d2));
        }
        return dArray;
    }

    private static double[][] a(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4;
        int n5 = (int)Math.floor((double)dArray2.length / 2.0);
        int n6 = dArray.length;
        int n7 = n6 - 2 * n5;
        int n8 = n5 + n7 - 1;
        int n9 = n6;
        double[][] dArray3 = new double[n9][n9];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                int n10;
                d2 = dArray[n4][n3];
                if (d2 == 0.0) continue;
                n2 = (n8 < n4 + n5 ? n8 : n4 + n5) + 1;
                int n11 = n10 = n5 > n4 - n5 ? n5 : n4 - n5;
                while (n10 < n2) {
                    double[] dArray4 = dArray3[n10];
                    int n12 = n3;
                    dArray4[n12] = dArray4[n12] + d2 * dArray2[n10 - (n4 - n5)];
                    ++n10;
                }
            }
        }
        int n13 = n7;
        dArray = new double[n13][n13];
        for (n4 = n5; n4 < n8 + 1; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray3[n4][n3];
                if (d2 == 0.0) continue;
                n2 = (n8 < n3 + n5 ? n8 : n3 + n5) + 1;
                int n14 = n7 = n5 > n3 - n5 ? n5 : n3 - n5;
                while (n7 < n2) {
                    double[] dArray5 = dArray[n4 - n5];
                    int n15 = n7 - n5;
                    dArray5[n15] = dArray5[n15] + d2 * dArray2[n7 - (n3 - n5)];
                    ++n7;
                }
            }
        }
        return dArray;
    }

    private static Bitmap a(double[][] object, int[] nArray, double d2) {
        int n2 = nArray[nArray.length - 1];
        double d3 = (double)(nArray.length - 1) / d2;
        int n3 = ((double[][])object).length;
        int[] nArray2 = new int[n3 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = object[i3][i2];
                int n4 = i2 * n3 + i3;
                int n5 = (int)(d4 * d3);
                if (d4 != 0.0) {
                    if (n5 < nArray.length) {
                        nArray2[n4] = nArray[n5];
                        continue;
                    }
                    nArray2[n4] = n2;
                    continue;
                }
                nArray2[n4] = 0;
            }
        }
        int n6 = n3;
        Bitmap bitmap = Bitmap.createBitmap((int)n6, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        object = bitmap;
        int n7 = n3;
        bitmap.setPixels(nArray2, 0, n3, 0, 0, n7, n7);
        return object;
    }

    private static double a(Collection<WeightedLatLng> object, cu cu2, int n2, int n3) {
        double d2 = cu2.c;
        double d3 = cu2.a;
        double d4 = cu2.d;
        double d5 = cu2.b;
        double d6 = d2 - d3 > d4 - d5 ? d2 - d3 : d4 - d5;
        double d7 = (double)((int)((double)(n3 / (2 * n2)) + 0.5)) / d6;
        cu2 = new LongSparseArray();
        double d8 = 0.0;
        object = object.iterator();
        while (object.hasNext()) {
            Double d9;
            WeightedLatLng weightedLatLng = (WeightedLatLng)object.next();
            double d10 = weightedLatLng.getPoint().x;
            double d11 = weightedLatLng.getPoint().y;
            n3 = (int)((d10 - d3) * d7);
            int n4 = (int)((d11 - d5) * d7);
            LongSparseArray longSparseArray = (LongSparseArray)cu2.get(n3);
            if (longSparseArray == null) {
                longSparseArray = new LongSparseArray();
                cu2.put(n3, longSparseArray);
            }
            if ((d9 = (Double)longSparseArray.get((long)n4)) == null) {
                d9 = 0.0;
            }
            d9 = d9 + weightedLatLng.intensity;
            longSparseArray.put((long)n4, (Object)d9);
            if (!(d9 > d8)) continue;
            d8 = d9;
        }
        return d8;
    }

    @Override
    public int getTileHeight() {
        return 256;
    }

    @Override
    public int getTileWidth() {
        return 256;
    }

    /* synthetic */ HeatmapTileProvider(Builder builder, byte by2) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Collection<WeightedLatLng> data;
        private int radius = 12;
        private Gradient gradient = DEFAULT_GRADIENT;
        private double opacity = 0.6;

        public Builder data(Collection<LatLng> collection) {
            return this.weightedData(HeatmapTileProvider.c(collection));
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            this.data = collection;
            return this;
        }

        public Builder radius(int n2) {
            this.radius = Math.max(10, Math.min(n2, 50));
            return this;
        }

        public Builder gradient(Gradient gradient) {
            this.gradient = gradient;
            return this;
        }

        public Builder transparency(double d2) {
            this.opacity = Math.max(0.0, Math.min(d2, 1.0));
            return this;
        }

        public HeatmapTileProvider build() {
            if (this.data == null || this.data.size() == 0) {
                try {
                    throw new AMapException("No input points.");
                }
                catch (AMapException aMapException) {
                    AMapException aMapException2 = aMapException;
                    aMapException.getErrorMessage();
                    aMapException2.printStackTrace();
                    return null;
                }
            }
            try {
                return new HeatmapTileProvider(this, 0);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }
    }
}

