/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.col.3n.dl;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBoundsCreator;
import com.amap.api.maps.model.RuntimeRemoteException;

public final class LatLngBounds
implements Parcelable {
    private static final String CLASSNAME = "LatLngBounds";
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int mVersionCode;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n2, LatLng latLng, LatLng latLng2) {
        boolean bl2 = true;
        try {
            if (latLng == null) {
                throw new RuntimeRemoteException("null southwest");
            }
            if (latLng2 == null) {
                throw new RuntimeRemoteException("null northeast");
            }
            if (latLng2.latitude < latLng.latitude) {
                throw new RuntimeRemoteException("southern latitude exceeds northern latitude (" + latLng.latitude + " > " + latLng2.latitude + ")");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl2 = false;
        }
        this.mVersionCode = bl2 ? n2 : 0;
        this.southwest = bl2 ? latLng : null;
        this.northeast = bl2 ? latLng2 : null;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    final int a() {
        return this.mVersionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean contains(LatLng latLng) {
        if (latLng == null) {
            return false;
        }
        if (this.northeast == null || this.southwest == null) {
            return false;
        }
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public final boolean contains(LatLngBounds latLngBounds) {
        boolean bl2 = false;
        if (latLngBounds == null) {
            return false;
        }
        if (this.contains(latLngBounds.southwest) && this.contains(latLngBounds.northeast)) {
            bl2 = true;
        }
        return bl2;
    }

    public final boolean intersects(LatLngBounds latLngBounds) {
        if (latLngBounds == null) {
            return false;
        }
        if (this.northeast == null || this.southwest == null) {
            return false;
        }
        return this.a(latLngBounds) || latLngBounds.a(this);
    }

    private boolean a(LatLngBounds latLngBounds) {
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null) {
            return false;
        }
        double d2 = latLngBounds.northeast.longitude + latLngBounds.southwest.longitude - this.northeast.longitude - this.southwest.longitude;
        double d3 = this.northeast.longitude - this.southwest.longitude + latLngBounds.northeast.longitude - this.southwest.longitude;
        double d4 = latLngBounds.northeast.latitude + latLngBounds.southwest.latitude - this.northeast.latitude - this.southwest.latitude;
        double d5 = this.northeast.latitude - this.southwest.latitude + latLngBounds.northeast.latitude - latLngBounds.southwest.latitude;
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    public final LatLngBounds including(LatLng latLng) {
        if (latLng == null) {
            return this;
        }
        if (this.northeast == null || this.southwest == null) {
            return this;
        }
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.c(d5, d6) < LatLngBounds.d(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        try {
            return new LatLngBounds(new LatLng(d2, d5, false), new LatLng(d3, d4, false));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this;
        }
    }

    private static double c(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double d(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public final int hashCode() {
        return dl.a(new Object[]{this.southwest, this.northeast});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        object = (LatLngBounds)object;
        return this.southwest.equals(((LatLngBounds)object).southwest) && this.northeast.equals(((LatLngBounds)object).northeast);
    }

    public final String toString() {
        return dl.a(dl.a("southwest", (Object)this.southwest), dl.a("northeast", (Object)this.northeast));
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        LatLngBoundsCreator.a(this, parcel, n2);
    }

    public static final class Builder {
        private double mSouth = Double.POSITIVE_INFINITY;
        private double mNorth = Double.NEGATIVE_INFINITY;
        private double mWest = Double.NaN;
        private double mEast = Double.NaN;

        /*
         * Enabled aggressive block sorting
         */
        public final Builder include(LatLng latLng) {
            if (latLng == null) {
                return this;
            }
            this.mSouth = Math.min(this.mSouth, latLng.latitude);
            this.mNorth = Math.max(this.mNorth, latLng.latitude);
            double d2 = latLng.longitude;
            if (Double.isNaN(this.mWest)) {
                this.mWest = d2;
            } else {
                if (this.a(d2)) return this;
                if (LatLngBounds.c(this.mWest, d2) < LatLngBounds.d(this.mEast, d2)) {
                    this.mWest = d2;
                    return this;
                }
            }
            this.mEast = d2;
            return this;
        }

        private boolean a(double d2) {
            if (this.mWest <= this.mEast) {
                return this.mWest <= d2 && d2 <= this.mEast;
            }
            return this.mWest <= d2 || d2 <= this.mEast;
        }

        public final LatLngBounds build() {
            if (Double.isNaN(this.mWest)) {
                return null;
            }
            if (this.mWest > this.mEast) {
                double d2 = this.mWest;
                this.mWest = this.mEast;
                this.mEast = d2;
            }
            if (this.mSouth > this.mNorth) {
                double d3 = this.mSouth;
                this.mSouth = this.mNorth;
                this.mNorth = d3;
            }
            return new LatLngBounds(new LatLng(this.mSouth, this.mWest, false), new LatLng(this.mNorth, this.mEast, false));
        }
    }
}

