/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.amap.api.col.3n.gz;
import com.amap.api.col.3n.hc;
import com.amap.api.col.3n.jr;
import com.amap.api.navi.AMapHudViewListener;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.AMapNaviListener;
import com.amap.api.navi.model.AMapCalcRouteResult;
import com.amap.api.navi.model.AMapLaneInfo;
import com.amap.api.navi.model.AMapModelCross;
import com.amap.api.navi.model.AMapNaviCameraInfo;
import com.amap.api.navi.model.AMapNaviCross;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.AMapNaviRouteNotifyData;
import com.amap.api.navi.model.AMapNaviTrafficFacilityInfo;
import com.amap.api.navi.model.AMapServiceAreaInfo;
import com.amap.api.navi.model.AimLessModeCongestionInfo;
import com.amap.api.navi.model.AimLessModeStat;
import com.amap.api.navi.model.NaviInfo;
import com.amap.api.navi.view.AutoNaviHudMirrorImage;

public class AMapHudView
extends FrameLayout
implements View.OnClickListener,
View.OnTouchListener,
AMapNaviListener {
    static final int[] HUD_IMG_ACTIONS = new int[]{2130837608, 2130837608, 2130837600, 2130837602, 2130837603, 2130837604, 2130837605, 2130837606, 2130837607, 2130837608, 2130837590, 2130837591, 2130837592, 2130837593, 2130837594, 2130837595, 2130837596, 2130837642, 2130837643, 2130837650, 2130837645};
    private static final long DELAY_MILLIS = 2000L;
    private AMapHudViewListener aMapHudVewListener;
    private View frameLayout;
    private AMapNavi mAMapNavi;
    private int mWidth = 480;
    private int mHeight = 800;
    private int hudMode = 1;
    private boolean isHudMenu = true;
    private Handler disappearHudHandler = new Handler();
    private TextView limitSpeedTextView;
    private CheckBox mMirrorModeCheckBox;
    private AutoNaviHudMirrorImage autonaviHudMirrorImage;
    private TextView restDistanceTime;
    private TextView nextRoadNameText;
    private TextView restDistanceText;
    private ImageView nextTurnImg;
    private TextView nextRoadDistanceText;
    private View titleBtnGoBack;
    private View mHudMirrorTitle;
    private NaviInfo mLastNaviInfo;
    private Runnable disappearHudTitleRunnable = new Runnable(){

        public final void run() {
            try {
                AMapHudView.this.loadHideHudTitleAnimation();
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                jr.c(throwable2, "AMapHudView", "disappearHudTitleRunnable");
                return;
            }
        }
    };
    private CompoundButton.OnCheckedChangeListener mOnCheckedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public final void onCheckedChanged(CompoundButton object, boolean bl2) {
            try {
                if (AMapHudView.this.autonaviHudMirrorImage == null) {
                    return;
                }
                if (bl2) {
                    AMapHudView.this.hudMode = 2;
                } else {
                    AMapHudView.this.hudMode = 1;
                }
                AMapHudView.this.setCheckBoxAndMirrorImageState(bl2);
                AMapHudView.this.removeCallbacks();
                AMapHudView.this.disappearHudHandler.postDelayed(AMapHudView.this.disappearHudTitleRunnable, 2000L);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throwable.printStackTrace();
                jr.c((Throwable)object, "AMapHudView", "mOnCheckedChangeListener");
                return;
            }
        }
    };
    private String restTimeTextStr;
    private String nextRoadNameTextStr;
    private String restDistanceTextStr;
    private SpannableString nextRoadDisTextSpannableStr = null;
    private int resId;

    public AMapHudView(Context object, AttributeSet attributeSet, int n2) {
        super(object, attributeSet, n2);
        try {
            this.init((Context)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs, int defStyle) ");
            return;
        }
    }

    public AMapHudView(Context object, AttributeSet attributeSet) {
        super(object, attributeSet);
        try {
            this.init((Context)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "AMapHudView(Context context, AttributeSet attrs) ");
            return;
        }
    }

    public AMapHudView(Context object) {
        super(object);
        try {
            this.init((Context)object);
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "AMapHudView(Context context) ");
            return;
        }
    }

    private void init(Context object) {
        try {
            this.mAMapNavi = AMapNavi.getInstance(object);
            this.mAMapNavi.addAMapNaviListener(this);
            this.initLayout();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "init(Context context)");
            return;
        }
    }

    private void initLayout() {
        boolean bl2 = ((Activity)this.getContext()).getRequestedOrientation() == 0 || this.getResources().getConfiguration().orientation == 2;
        this.frameLayout = hc.a(this.getContext(), bl2 ? 2130903043 : 2130903042, null);
        AMapHudView aMapHudView = this;
        aMapHudView.addView(aMapHudView.frameLayout);
        this.initResolution();
        this.initWidget();
    }

    private void initResolution() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.mWidth = displayMetrics.widthPixels;
        this.mHeight = displayMetrics.heightPixels;
    }

    private void initWidget() {
        this.mHudMirrorTitle = this.frameLayout.findViewById(2147479577);
        this.autonaviHudMirrorImage = (AutoNaviHudMirrorImage)this.frameLayout.findViewById(2147479570);
        this.mMirrorModeCheckBox = (CheckBox)this.frameLayout.findViewById(2147479579);
        this.nextRoadNameText = (TextView)this.frameLayout.findViewById(2147479571);
        this.restDistanceText = (TextView)this.frameLayout.findViewById(2147479574);
        this.nextTurnImg = (ImageView)this.frameLayout.findViewById(2147479572);
        this.nextRoadDistanceText = (TextView)this.frameLayout.findViewById(2147479573);
        this.titleBtnGoBack = this.frameLayout.findViewById(2147479578);
        this.restDistanceTime = (TextView)this.frameLayout.findViewById(2147479575);
        this.limitSpeedTextView = (TextView)this.frameLayout.findViewById(2147479576);
        this.getScreenInfo();
        this.setWidgetListener();
        this.updateHudWidgetContent();
    }

    public int getHudViewMode() {
        return this.hudMode;
    }

    public void setHudViewMode(int n2) {
        try {
            this.hudMode = n2;
            AMapHudView aMapHudView = this;
            aMapHudView.setCheckBoxAndMirrorImageState(aMapHudView.hudMode == 2);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            jr.c(throwable2, "AMapHudView", "setHudViewMode(int mode)");
            return;
        }
    }

    public boolean getHudMenuEnabled() {
        return this.isHudMenu;
    }

    public void setHudMenuEnabled(Boolean bl2) {
        this.isHudMenu = bl2;
    }

    public final void onCreate(Bundle bundle) {
    }

    public final void onResume() {
    }

    public final void onPause() {
    }

    public final void onSaveInstanceState(Bundle bundle) {
    }

    public final void onDestroy() {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
            }
            if (this.disappearHudHandler != null) {
                this.disappearHudHandler.removeCallbacksAndMessages(null);
                this.disappearHudHandler = null;
            }
            this.mAMapNavi.removeAMapNaviListener(this);
            AMapNavi.destroy();
            hc.a();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            jr.c(throwable2, "AMapHudView", "onDestroy()");
            return;
        }
    }

    public void setHudViewListener(AMapHudViewListener aMapHudViewListener) {
        this.aMapHudVewListener = aMapHudViewListener;
    }

    public boolean onTouchHudMirrorEvent(MotionEvent object) {
        try {
            if (!this.isHudMenu) {
                return true;
            }
            this.loadShowHudTitleAnimation();
            this.removeCallbacks();
            this.disappearHudHandler.postDelayed(this.disappearHudTitleRunnable, 2000L);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "onTouchHudMirrorEvent(MotionEvent event)");
        }
        return true;
    }

    private void loadShowHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 8) {
            Animation animation = hc.a(this.getContext(), 2130968578);
            this.mHudMirrorTitle.setVisibility(0);
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    private void getScreenInfo() {
        if (this.autonaviHudMirrorImage == null) {
            return;
        }
        this.autonaviHudMirrorImage.mWidth = this.mWidth;
        this.autonaviHudMirrorImage.mHeight = this.mHeight - 50;
    }

    private void updateHudWidgetContent() {
        if (this.nextRoadNameText != null) {
            this.nextRoadNameText.setText((CharSequence)this.nextRoadNameTextStr);
        }
        if (this.nextRoadDistanceText != null) {
            this.nextRoadDistanceText.setText((CharSequence)this.nextRoadDisTextSpannableStr);
        }
        if (this.restDistanceText != null) {
            this.restDistanceText.setText((CharSequence)this.restDistanceTextStr);
        }
        if (this.restDistanceTime != null) {
            this.restDistanceTime.setText((CharSequence)this.restTimeTextStr);
        }
        if (this.nextTurnImg != null) {
            Drawable drawable2 = hc.b(this.getContext()).getDrawable(HUD_IMG_ACTIONS[this.resId]);
            this.nextTurnImg.setBackgroundDrawable(drawable2);
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.invalidate();
                this.autonaviHudMirrorImage.postInvalidate();
            }
        }
    }

    private void setWidgetListener() {
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setAMapHudView(this);
            AMapHudView aMapHudView = this;
            aMapHudView.setOnTouchListener(aMapHudView);
        }
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setOnCheckedChangeListener(this.mOnCheckedChangeListener);
        }
        if (this.titleBtnGoBack != null) {
            this.titleBtnGoBack.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void removeCallbacks() {
        if (this.disappearHudHandler != null && this.disappearHudTitleRunnable != null) {
            this.disappearHudHandler.removeCallbacks(this.disappearHudTitleRunnable);
        }
    }

    private void setCheckBoxAndMirrorImageState(boolean bl2) {
        if (this.mMirrorModeCheckBox != null) {
            this.mMirrorModeCheckBox.setChecked(bl2);
        }
        if (this.autonaviHudMirrorImage != null) {
            this.autonaviHudMirrorImage.setMirrorState(bl2);
            this.autonaviHudMirrorImage.invalidate();
            this.autonaviHudMirrorImage.postInvalidate();
        }
    }

    private void loadHideHudTitleAnimation() {
        if (this.mHudMirrorTitle != null && this.mHudMirrorTitle.getVisibility() == 0) {
            Animation animation = hc.a(this.getContext(), 2130968579);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public final void onAnimationStart(Animation animation) {
                }

                public final void onAnimationRepeat(Animation animation) {
                }

                public final void onAnimationEnd(Animation animation) {
                    AMapHudView.this.mHudMirrorTitle.setVisibility(8);
                }
            });
            this.mHudMirrorTitle.startAnimation(animation);
        }
    }

    protected void onConfigurationChanged(Configuration object) {
        try {
            if (this.autonaviHudMirrorImage != null) {
                this.autonaviHudMirrorImage.recycleMirrorBitmap();
                this.autonaviHudMirrorImage = null;
            }
            this.removeAllViews();
            this.initLayout();
            AMapHudView aMapHudView = this;
            aMapHudView.updateHudUI(aMapHudView.mLastNaviInfo);
            AMapHudView aMapHudView2 = this;
            aMapHudView2.setCheckBoxAndMirrorImageState(aMapHudView2.hudMode == 2);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "onConfigurationChanged(Configuration newConfig)");
            return;
        }
    }

    private void updateHudUI(NaviInfo object) {
        if (object == null) {
            return;
        }
        try {
            this.nextRoadNameTextStr = ((NaviInfo)object).getNextRoadName();
            this.restDistanceTextStr = gz.a(((NaviInfo)object).getPathRetainDistance());
            this.nextRoadDisTextSpannableStr = this.switchStrFromMeter(((NaviInfo)object).getCurStepRetainDistance());
            this.restTimeTextStr = gz.b(((NaviInfo)object).getPathRetainTime());
            this.resId = ((NaviInfo)object).getIconType();
            this.updateHudWidgetContent();
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "updateHudUI(NaviInfo naviInfo)");
            return;
        }
    }

    private SpannableString switchStrFromMeter(int n2) {
        if (n2 >= 1000) {
            float f2 = (float)Math.round((float)n2 / 1000.0f * 10.0f) / 10.0f;
            AMapHudView aMapHudView = this;
            return aMapHudView.getSpanableString(aMapHudView.getContext(), String.valueOf(f2), "\u516c\u91cc");
        }
        AMapHudView aMapHudView = this;
        return aMapHudView.getSpanableString(aMapHudView.getContext(), String.valueOf(n2), "\u7c73");
    }

    private SpannableString getSpanableString(Context context, String string2, String string3) {
        SpannableString spannableString = new SpannableString((CharSequence)(string2 + string3));
        try {
            int n2 = gz.a(context, 60);
            int n3 = gz.a(context, 30);
            int n4 = string2.length();
            spannableString.setSpan((Object)new AbsoluteSizeSpan(n2), 0, n4, 33);
            spannableString.setSpan((Object)new ForegroundColorSpan(-1), 0, n4, 33);
            int n5 = n4;
            n4 = n5 + string3.length();
            spannableString.setSpan((Object)new AbsoluteSizeSpan(n3), n5, n4, 33);
            spannableString.setSpan((Object)new ForegroundColorSpan(-1), n5, n4, 33);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return spannableString;
    }

    public void onClick(View object) {
        try {
            if (this.titleBtnGoBack == object && this.aMapHudVewListener != null) {
                this.aMapHudVewListener.onHudViewCancel();
            }
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "onClick(View v)");
            return;
        }
    }

    public boolean onTouch(View object, MotionEvent motionEvent) {
        try {
            this.onTouchHudMirrorEvent(motionEvent);
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "onTouch(View arg0, MotionEvent arg1)");
        }
        return false;
    }

    public void onInitNaviFailure() {
    }

    public void onInitNaviSuccess() {
    }

    public void onStartNavi(int n2) {
    }

    public void onTrafficStatusUpdate() {
    }

    public void onLocationChange(AMapNaviLocation aMapNaviLocation) {
    }

    public void onGetNavigationText(int n2, String string2) {
    }

    public void onGetNavigationText(String string2) {
    }

    public void onEndEmulatorNavi() {
    }

    public void onArriveDestination() {
    }

    public void onCalculateRouteFailure(int n2) {
    }

    public void onReCalculateRouteForYaw() {
    }

    public void onReCalculateRouteForTrafficJam() {
    }

    public void onArrivedWayPoint(int n2) {
    }

    public void onGpsOpenStatus(boolean bl2) {
    }

    public void onNaviInfoUpdate(NaviInfo object) {
        try {
            this.mLastNaviInfo = object;
            this.updateHudUI((NaviInfo)object);
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
            jr.c((Throwable)object, "AMapHudView", "onNaviInfoUpdate(NaviInfo naviinfo)");
            return;
        }
    }

    public void updateCameraInfo(AMapNaviCameraInfo[] aMapNaviCameraInfoArray) {
        if (this.limitSpeedTextView == null) {
            return;
        }
        if (aMapNaviCameraInfoArray == null || aMapNaviCameraInfoArray.length == 0) {
            return;
        }
        if (this.mAMapNavi.getNaviSetting().isMonitorCameraEnabled() && this.mAMapNavi.getEngineType() == 0 && aMapNaviCameraInfoArray[0].getCameraSpeed() > 0) {
            this.limitSpeedTextView.setText((CharSequence)String.valueOf(aMapNaviCameraInfoArray[0].getCameraSpeed()));
            this.limitSpeedTextView.setVisibility(0);
            return;
        }
        this.limitSpeedTextView.setVisibility(8);
    }

    public void onServiceAreaUpdate(AMapServiceAreaInfo[] aMapServiceAreaInfoArray) {
    }

    public void showCross(AMapNaviCross aMapNaviCross) {
    }

    public void hideCross() {
    }

    public void showLaneInfo(AMapLaneInfo[] aMapLaneInfoArray, byte[] byArray, byte[] byArray2) {
    }

    public void showLaneInfo(AMapLaneInfo aMapLaneInfo) {
    }

    public void hideLaneInfo() {
    }

    public void onCalculateRouteSuccess(int[] nArray) {
    }

    public void notifyParallelRoad(int n2) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo aMapNaviTrafficFacilityInfo) {
    }

    public void OnUpdateTrafficFacility(AMapNaviTrafficFacilityInfo[] aMapNaviTrafficFacilityInfoArray) {
    }

    public void updateAimlessModeStatistics(AimLessModeStat aimLessModeStat) {
    }

    public void updateAimlessModeCongestionInfo(AimLessModeCongestionInfo aimLessModeCongestionInfo) {
    }

    public void onPlayRing(int n2) {
    }

    public void showModeCross(AMapModelCross aMapModelCross) {
    }

    public void hideModeCross() {
    }

    public void onGpsSignalWeak(boolean bl2) {
    }

    public void updateIntervalCameraInfo(AMapNaviCameraInfo aMapNaviCameraInfo, AMapNaviCameraInfo aMapNaviCameraInfo2, int n2) {
    }

    public void onCalculateRouteSuccess(AMapCalcRouteResult aMapCalcRouteResult) {
    }

    public void onCalculateRouteFailure(AMapCalcRouteResult aMapCalcRouteResult) {
    }

    public void onNaviRouteNotify(AMapNaviRouteNotifyData aMapNaviRouteNotifyData) {
    }
}

