/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"Override"})
public class CheckPermissionsActivity
extends Activity {
    protected String[] needPermissions = null;
    private static final int PERMISSION_REQUEST_CODE = 0;
    public static final int VERSION_CODES_M = 23;
    private boolean isNeedCheck = true;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.isAndroidRVersion()) {
            this.needPermissions = new String[]{"android.permission.ACCESS_BACKGROUND_LOCATION", "android.permission.BLUETOOTH_CONNECT", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.READ_PHONE_STATE"};
            return;
        }
        if (this.isAndroidQVersion()) {
            this.needPermissions = new String[]{"android.permission.ACCESS_BACKGROUND_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.READ_PHONE_STATE"};
            return;
        }
        this.needPermissions = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    }

    protected void onResume() {
        try {
            super.onResume();
            if (this.isNeedCheck && this.needPermissions != null) {
                CheckPermissionsActivity checkPermissionsActivity = this;
                checkPermissionsActivity.checkPermissions(checkPermissionsActivity.needPermissions);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @TargetApi(value=23)
    private void checkPermissions(String ... object) {
        try {
            if (Build.VERSION.SDK_INT >= 23 && this.getApplicationInfo().targetSdkVersion >= 23 && (object = this.findDeniedPermissions((String[])object)) != null && object.size() > 0) {
                try {
                    Object object2 = object;
                    object = object2.toArray(new String[object2.size()]);
                    ((Object)((Object)this)).getClass().getMethod("requestPermissions", String[].class, Integer.TYPE).invoke((Object)this, object, 0);
                    return;
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @TargetApi(value=23)
    private List<String> findDeniedPermissions(String[] stringArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (Build.VERSION.SDK_INT >= 23 && this.getApplicationInfo().targetSdkVersion >= 23) {
                for (String string2 : stringArray) {
                    if (this.checkMySelfPermission(string2) == 0 && !this.shouldShowMyRequestPermissionRationale(string2)) continue;
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private int checkMySelfPermission(String string2) {
        try {
            return (Integer)((Object)((Object)this)).getClass().getMethod("checkSelfPermission", String.class).invoke((Object)this, string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private boolean shouldShowMyRequestPermissionRationale(String string2) {
        try {
            return (Boolean)((Object)((Object)this)).getClass().getMethod("shouldShowRequestPermissionRationale", String.class).invoke((Object)this, string2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean verifyPermissions(String[] stringArray, int[] nArray) {
        try {
            boolean bl2 = false;
            if (stringArray != null && nArray != null && nArray.length == stringArray.length) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(stringArray[i2])) {
                        if (nArray[i2] == 0) continue;
                        bl2 = true;
                        continue;
                    }
                    if (nArray[i2] == 0) continue;
                    return false;
                }
            }
            if (bl2) {
                this.isNeedCheck = false;
                return true;
            }
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (nArray2[i3] == 0) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        try {
            if (Build.VERSION.SDK_INT >= 23 && n2 == 0 && !this.verifyPermissions(stringArray, nArray)) {
                this.showMissingPermissionDialog();
                this.isNeedCheck = false;
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void showMissingPermissionDialog() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)"\u63d0\u793a");
            builder.setMessage((CharSequence)"\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\n\n\u8bf7\u70b9\u51fb\"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650");
            builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n2) {
                    try {
                        CheckPermissionsActivity.this.finish();
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
            builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n2) {
                    try {
                        CheckPermissionsActivity.this.startAppSettings();
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
            builder.setCancelable(false);
            builder.show();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void startAppSettings() {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
            this.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private boolean isAndroidQVersion() {
        return Build.VERSION.SDK_INT > 28 && this.getApplicationInfo().targetSdkVersion > 28;
    }

    private boolean isAndroidRVersion() {
        return Build.VERSION.SDK_INT >= 30 && this.getApplicationInfo().targetSdkVersion >= 30;
    }
}

