/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.model;

import com.autonavi.ae.guide.NaviCameraInfo;
import com.autonavi.ae.route.RouteCamera;

public class AMapNaviCameraInfo {
    private double longitude;
    private double latitude;
    private int cameraDistance;
    private int cameraType;
    private int cameraSpeed;
    private int[] speed = new int[1];
    private int averageSpeed;
    private int reasonableSpeedInRemainDist;
    private int intervalLength;
    private int intervalRemainDistance;

    public AMapNaviCameraInfo() {
    }

    public AMapNaviCameraInfo(NaviCameraInfo naviCameraInfo) {
        try {
            this.longitude = naviCameraInfo.lon;
            this.latitude = naviCameraInfo.lat;
            this.cameraType = naviCameraInfo.type;
            this.cameraSpeed = naviCameraInfo.speed;
            this.cameraDistance = naviCameraInfo.distance;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public AMapNaviCameraInfo(RouteCamera routeCamera) {
        try {
            this.longitude = routeCamera.longitude;
            this.latitude = routeCamera.latitude;
            this.cameraType = routeCamera.cameraType;
            this.cameraSpeed = routeCamera.cameraSpeed;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void update(NaviCameraInfo naviCameraInfo) {
        try {
            this.longitude = naviCameraInfo.lon;
            this.latitude = naviCameraInfo.lat;
            this.cameraDistance = naviCameraInfo.distance == -1 ? 0 : naviCameraInfo.distance;
            this.cameraType = naviCameraInfo.type;
            this.cameraSpeed = naviCameraInfo.speed == -1 ? 0 : naviCameraInfo.speed;
            this.intervalLength = naviCameraInfo.intervalLength == -1 ? 0 : naviCameraInfo.intervalLength;
            this.averageSpeed = naviCameraInfo.intervalAverageSpeed == -1 ? 0 : naviCameraInfo.intervalAverageSpeed;
            this.reasonableSpeedInRemainDist = naviCameraInfo.intervalReasonableSpeedInRemainDist == -1 ? 0 : naviCameraInfo.intervalReasonableSpeedInRemainDist;
            this.intervalRemainDistance = naviCameraInfo.intervalRemainDistance == -1 ? 0 : naviCameraInfo.intervalRemainDistance;
            this.speed[0] = this.cameraSpeed;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public int getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(int n2) {
        this.averageSpeed = n2;
    }

    public int getReasonableSpeedInRemainDist() {
        return this.reasonableSpeedInRemainDist;
    }

    public void setReasonableSpeedInRemainDist(int n2) {
        this.reasonableSpeedInRemainDist = n2;
    }

    public int getDistance() {
        return this.intervalLength;
    }

    public void setDistance(int n2) {
        this.intervalLength = n2;
    }

    public int[] getSpeed() {
        return this.speed;
    }

    public void setSpeed(int[] nArray) {
        this.speed = nArray;
    }

    public double getX() {
        return this.longitude;
    }

    public double getY() {
        return this.latitude;
    }

    public int getCameraDistance() {
        return this.cameraDistance;
    }

    public int getCameraSpeed() {
        return this.cameraSpeed;
    }

    public int getCameraType() {
        return this.cameraType;
    }

    public int getIntervalRemainDistance() {
        return this.intervalRemainDistance;
    }

    public void setIntervalRemainDistance(int n2) {
        this.intervalRemainDistance = n2;
    }
}

