/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.amap.api.col.3n.gz;
import com.amap.api.col.3n.hc;
import com.amap.api.navi.AMapNaviView;
import com.amap.api.navi.model.AMapLaneInfo;

public class DriveWayView
extends LinearLayout {
    private int driveWayWidth = 0;
    private int driveWayHeight = 0;
    private int driveWaySize = 0;
    private int dividerWidth;
    private int[] driveWayBackgroundId = new int[]{2130838081, 2130838082, 2130838083, 2130838084, 2130838085, 2130838086, 2130838087, 2130838088, 2130838089, 2130838090, 2130838091, 2130838092, 2130838093, 2130838094, 2130838095, 2130838096, 2130838096, 2130838097, 2130838098, 2130838099, 2130838100, 2130838101, 2130838102, 2130838102};
    private int[] driveWayForegroundId = new int[]{2130838103, 2130838104, 2130838083, 2130838108, 2130838085, 2130838112, 2130838087, 2130838088, 2130838120, 2130838090, 2130838091, 2130838092, 2130838093, 2130838134, 2130838095, 2130838096, 2130838096, 2130838097, 2130838098, 2130838099, 2130838100, 2130838156, 2130838157, 2130838157};
    private AMapNaviView mAMapNaviView = null;
    LinearLayout.LayoutParams imgLp;
    LinearLayout.LayoutParams dividerLp;
    private Resources mResources;

    public DriveWayView(Context context) {
        this(context, null);
    }

    public DriveWayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DriveWayView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mResources = hc.b(context);
        this.driveWayWidth = gz.a(context, 36);
        this.driveWayHeight = gz.a(context, 56);
        this.driveWaySize = 0;
        this.dividerLp = new LinearLayout.LayoutParams(-2, this.driveWayHeight);
        this.dividerLp.gravity = 16;
        this.imgLp = new LinearLayout.LayoutParams(this.driveWayWidth, this.driveWayHeight);
        this.imgLp.gravity = 17;
        this.dividerWidth = this.mResources.getDrawable(2130837839).getIntrinsicWidth();
        this.setGravity(1);
    }

    public void setAMapNaviView(AMapNaviView aMapNaviView) {
        this.mAMapNaviView = aMapNaviView;
    }

    public void loadDriveWayBitmap(byte[] byArray, byte[] byArray2) {
        try {
            this.removeAllViews();
            this.driveWaySize = this.parseDriveWaySize(byArray);
            if (this.driveWaySize == 0) {
                return;
            }
            for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
                this.buildDriveWay(byArray[i2], byArray2[i2], i2, this.driveWaySize);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void loadDriveWayBitmap(AMapLaneInfo aMapLaneInfo) {
        try {
            this.removeAllViews();
            this.driveWaySize = aMapLaneInfo.laneCount;
            if (this.driveWaySize == 0) {
                return;
            }
            for (int i2 = 0; i2 < this.driveWaySize; ++i2) {
                this.buildDriveWay(aMapLaneInfo.backgroundLane[i2], aMapLaneInfo.frontLane[i2], i2, this.driveWaySize);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private int parseDriveWaySize(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((byArray[i2] & 0xFF) != 255) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    private boolean isThisLaneRecommended(int n2) {
        return n2 != 255;
    }

    private boolean isComplexLane(int n2) {
        return n2 == 14 || n2 == 2 || n2 == 4 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 12 || n2 == 6 || n2 == 7 || n2 == 16 || n2 == 17 || n2 == 18 || n2 == 19 || n2 == 20;
    }

    private int complexBitmap(int n2, int n3) {
        int n4 = 0;
        if (n2 == 10) {
            if (n3 == 0) {
                n4 = 2130838124;
            } else if (n3 == 8) {
                n4 = 2130838125;
            }
        } else if (n2 == 9) {
            if (n3 == 0) {
                n4 = 2130838121;
            } else if (n3 == 5) {
                n4 = 2130838122;
            }
        } else if (n2 == 2) {
            if (n3 == 0) {
                n4 = 2130838105;
            } else if (n3 == 1) {
                n4 = 2130838106;
            }
        } else if (n2 == 4) {
            if (n3 == 0) {
                n4 = 2130838109;
            } else if (n3 == 3) {
                n4 = 2130838110;
            }
        } else if (n2 == 6) {
            if (n3 == 1) {
                n4 = 2130838113;
            } else if (n3 == 3) {
                n4 = 2130838114;
            }
        } else if (n2 == 7) {
            if (n3 == 0) {
                n4 = 2130838116;
            } else if (n3 == 1) {
                n4 = 2130838117;
            } else if (n3 == 3) {
                n4 = 2130838118;
            }
        } else if (n2 == 11 || n2 == 14) {
            if (n3 == 5) {
                n4 = 2130838128;
            } else if (n3 == 1) {
                n4 = 2130838127;
            }
        } else if (n2 == 12) {
            if (n3 == 8) {
                n4 = 2130838131;
            } else if (n3 == 3) {
                n4 = 2130838130;
            }
        } else if (n2 == 16) {
            if (n3 == 0) {
                n4 = 2130838138;
            } else if (n3 == 1) {
                n4 = 2130838139;
            } else if (n3 == 5) {
                n4 = 2130838140;
            }
        } else if (n2 == 17) {
            if (n3 == 5) {
                n4 = 2130838143;
            } else if (n3 == 3) {
                n4 = 2130838142;
            }
        } else if (n2 == 18) {
            if (n3 == 1) {
                n4 = 2130838145;
            } else if (n3 == 5) {
                n4 = 2130838147;
            } else if (n3 == 3) {
                n4 = 2130838146;
            }
        } else if (n2 == 19) {
            if (n3 == 0) {
                n4 = 2130838149;
            } else if (n3 == 3) {
                n4 = 2130838150;
            } else if (n3 == 5) {
                n4 = 2130838151;
            }
        } else if (n2 == 21) {
            n4 = 2130838156;
        } else if (n2 == 23) {
            n4 = 2130838157;
        }
        n3 = n4;
        if (n3 == 0) {
            n3 = this.driveWayBackgroundId[n2];
        }
        return n3;
    }

    public void setDefaultTopMargin(int n2) {
        try {
            if (this.mAMapNaviView == null) {
                return;
            }
            n2 = !this.mAMapNaviView.isOrientationLandscape() && this.mAMapNaviView.isShowRoadEnlarge() ? n2 * 3 / 8 - (this.driveWayHeight >> 1) : (n2 += 10);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
            layoutParams.setMargins(0, n2, 0, 0);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void buildDriveWay(int n2, int n3, int n4, int n5) {
        int n6 = n5 == 1 ? 2130838275 : (n5 > 1 && n4 == 0 ? 2130838274 : (n5 > 1 && n4 == n5 - 1 ? 2130838276 : 2130838273));
        if (this.isComplexLane(n2)) {
            n2 = this.complexBitmap(n2, n3);
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(n2, n6), (ViewGroup.LayoutParams)this.imgLp);
        } else if (this.isThisLaneRecommended(n3)) {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(this.driveWayForegroundId[n3], n6), (ViewGroup.LayoutParams)this.imgLp);
        } else {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createImageView(this.driveWayBackgroundId[n2], n6), (ViewGroup.LayoutParams)this.imgLp);
        }
        if (n5 > 1 && n4 < n5 - 1) {
            DriveWayView driveWayView = this;
            driveWayView.addView(driveWayView.createLine(), (ViewGroup.LayoutParams)this.dividerLp);
        }
    }

    private View createImageView(int n2, int n3) {
        ImageView imageView = new ImageView(this.getContext());
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)n2);
        imageView.setImageBitmap(bitmap);
        imageView.setBackground(this.mResources.getDrawable(n3));
        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return imageView;
    }

    private View createLine() {
        ImageView imageView = new ImageView(this.getContext());
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)2130837839);
        imageView.setImageBitmap(bitmap);
        imageView.setBackgroundColor(this.mResources.getColor(2131034170));
        return imageView;
    }

    public int getDriveWaySize() {
        return this.driveWaySize;
    }

    public int getDriveWayBgHeight() {
        return this.driveWayHeight;
    }

    public int getDriveWayWidth() {
        return this.driveWayWidth;
    }

    public int getDriveWaysWidth() {
        return this.driveWayWidth * this.driveWaySize + (this.driveWaySize - 1) * this.dividerWidth;
    }
}

