/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.amap.api.col.3n.gz;
import com.amap.api.col.3n.hc;
import com.amap.api.navi.AMapNavi;
import com.amap.api.navi.R;
import com.amap.api.navi.model.AMapNaviPath;
import com.amap.api.navi.model.AMapNaviRouteGuideGroup;
import com.amap.api.navi.view.LoadingView;
import com.amap.api.navi.view.NaviGuideWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlidingTabLayout
extends RelativeLayout
implements View.OnClickListener {
    private ISlidingCallback callback;
    private View.OnClickListener listener;
    private NaviGuideWidget naviGuideWidget;
    private LinearLayout multipleRouteLayout;
    private RelativeLayout singleRouteLayout;
    private TextView singleRouteText;
    private LoadingView loadingView;
    private RelativeLayout tabInfoLayout;
    private TextView mRouteInfo;
    private TextView mLimitForbiddenInfo;
    private Button mTopNaviButton;
    private Button mFootEmulatorNaviButton;
    private Button mFootGPSNaviButton;
    private TextView[] mRouteTabStrategy = new TextView[3];
    private TextView[] mRouteTabTime = new TextView[3];
    private TextView[] mRouteTabDistance = new TextView[3];
    private LinearLayout[] routeTab = new LinearLayout[3];
    Drawable bgTab;
    Drawable bgTabPressed;
    int viewBgColor;
    int viewBgColorPressed;
    int titleTextColor;
    int titleTextColorPressed;
    int timeTextColor;
    int timeTextColorPressed;
    int distanceTextColor;
    int distanceTextColorPressed;

    public SlidingTabLayout(Context context) {
        this(context, null);
    }

    public SlidingTabLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getThemeAttrs(context);
        this.initView();
    }

    private void getThemeAttrs(Context context) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(R.styleable.amap_navi_chooserouteline);
        int n2 = typedArray.getResourceId(0, -1);
        int n3 = typedArray.getResourceId(1, -1);
        this.bgTab = hc.b(context).getDrawable(n2 == -1 ? 2130837760 : n2);
        this.bgTabPressed = hc.b(context).getDrawable(n3 == -1 ? 2130837813 : n3);
        this.viewBgColor = typedArray.getColor(2, Color.parseColor((String)"#E2E2E2"));
        this.viewBgColorPressed = typedArray.getColor(3, Color.parseColor((String)"#4287FF"));
        this.titleTextColor = typedArray.getColor(4, -16777216);
        this.titleTextColorPressed = typedArray.getColor(5, -1);
        this.timeTextColor = typedArray.getColor(6, -16777216);
        this.timeTextColorPressed = typedArray.getColor(7, Color.parseColor((String)"#4287FF"));
        this.distanceTextColor = typedArray.getColor(8, -16777216);
        this.distanceTextColorPressed = typedArray.getColor(9, Color.parseColor((String)"#4287FF"));
        typedArray.recycle();
    }

    private void initView() {
        hc.a(this.getContext(), 2130903065, (ViewGroup)this);
        this.tabInfoLayout = (RelativeLayout)this.findViewById(2147479797);
        this.multipleRouteLayout = (LinearLayout)this.findViewById(0x7FFFF0F7);
        this.routeTab[0] = (LinearLayout)this.findViewById(2147479800);
        this.routeTab[0].setOnClickListener((View.OnClickListener)this);
        this.mRouteTabStrategy[0] = (TextView)this.findViewById(2147479801);
        this.mRouteTabTime[0] = (TextView)this.findViewById(2147479802);
        this.mRouteTabDistance[0] = (TextView)this.findViewById(2147479803);
        this.routeTab[1] = (LinearLayout)this.findViewById(2147479804);
        this.routeTab[1].setOnClickListener((View.OnClickListener)this);
        this.mRouteTabStrategy[1] = (TextView)this.findViewById(2147479805);
        this.mRouteTabTime[1] = (TextView)this.findViewById(2147479806);
        this.mRouteTabDistance[1] = (TextView)this.findViewById(0x7FFFF0FF);
        this.routeTab[2] = (LinearLayout)this.findViewById(2147479808);
        this.routeTab[2].setOnClickListener((View.OnClickListener)this);
        this.mRouteTabStrategy[2] = (TextView)this.findViewById(2147479809);
        this.mRouteTabTime[2] = (TextView)this.findViewById(2147479810);
        this.mRouteTabDistance[2] = (TextView)this.findViewById(2147479811);
        this.singleRouteLayout = (RelativeLayout)this.findViewById(2147479812);
        this.singleRouteText = (TextView)this.findViewById(2147479813);
        this.naviGuideWidget = (NaviGuideWidget)this.findViewById(2147479638);
        this.mRouteInfo = (TextView)this.findViewById(2147479815);
        this.mLimitForbiddenInfo = (TextView)this.findViewById(2147479816);
        this.mTopNaviButton = (Button)this.findViewById(2147479817);
        this.mTopNaviButton.setOnClickListener((View.OnClickListener)this);
        this.loadingView = (LoadingView)this.findViewById(2147479641);
        this.mFootEmulatorNaviButton = (Button)this.findViewById(2147479819);
        this.mFootEmulatorNaviButton.setOnClickListener((View.OnClickListener)this);
        this.mFootGPSNaviButton = (Button)this.findViewById(2147479820);
        this.mFootGPSNaviButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setSlidingClickCallback(View.OnClickListener onClickListener) {
        this.listener = onClickListener;
    }

    public void setSlidingCallback(ISlidingCallback iSlidingCallback) {
        this.callback = iSlidingCallback;
    }

    public boolean selectRouteTab(int n2) {
        Drawable drawable2 = this.bgTab;
        Drawable drawable3 = this.bgTab;
        Drawable drawable4 = this.bgTab;
        int n3 = this.viewBgColor;
        int n4 = this.viewBgColor;
        int n5 = this.viewBgColor;
        int n6 = this.titleTextColor;
        int n7 = this.titleTextColor;
        int n8 = this.titleTextColor;
        int n9 = this.timeTextColor;
        int n10 = this.timeTextColor;
        int n11 = this.timeTextColor;
        int n12 = this.distanceTextColor;
        int n13 = this.distanceTextColor;
        int n14 = this.distanceTextColor;
        if (n2 == 2147479800) {
            drawable2 = this.bgTabPressed;
            n3 = this.viewBgColorPressed;
            n6 = this.titleTextColorPressed;
            n9 = this.timeTextColorPressed;
            n12 = this.distanceTextColorPressed;
            n2 = 12;
        } else if (n2 == 2147479804) {
            drawable3 = this.bgTabPressed;
            n4 = this.viewBgColorPressed;
            n7 = this.titleTextColorPressed;
            n10 = this.timeTextColorPressed;
            n13 = this.distanceTextColorPressed;
            n2 = 13;
        } else {
            drawable4 = this.bgTabPressed;
            n5 = this.viewBgColorPressed;
            n8 = this.titleTextColorPressed;
            n11 = this.timeTextColorPressed;
            n14 = this.distanceTextColorPressed;
            n2 = 14;
        }
        boolean bl2 = this.callback.selectRoute(n2);
        n2 = bl2 ? 1 : 0;
        if (bl2) {
            this.routeTab[0].setBackgroundDrawable(drawable2);
            this.routeTab[1].setBackgroundDrawable(drawable3);
            this.routeTab[2].setBackgroundDrawable(drawable4);
            this.mRouteTabStrategy[0].setBackgroundColor(n3);
            this.mRouteTabStrategy[1].setBackgroundColor(n4);
            this.mRouteTabStrategy[2].setBackgroundColor(n5);
            this.mRouteTabStrategy[0].setTextColor(n6);
            this.mRouteTabStrategy[1].setTextColor(n7);
            this.mRouteTabStrategy[2].setTextColor(n8);
            this.mRouteTabTime[0].setTextColor(n9);
            this.mRouteTabTime[1].setTextColor(n10);
            this.mRouteTabTime[2].setTextColor(n11);
            this.mRouteTabDistance[0].setTextColor(n12);
            this.mRouteTabDistance[1].setTextColor(n13);
            this.mRouteTabDistance[2].setTextColor(n14);
        }
        return n2 != 0;
    }

    public void updateRouteTable(int[] nArray) {
        HashMap<Integer, AMapNaviPath> hashMap = AMapNavi.getInstance(this.getContext()).getNaviPaths();
        if (nArray == null || hashMap == null || hashMap.size() != nArray.length) {
            return;
        }
        this.routeTab[0].setVisibility(8);
        this.routeTab[1].setVisibility(8);
        this.routeTab[2].setVisibility(8);
        String string2 = ",";
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object object = hashMap.get(nArray[i2]);
            if (object == null) continue;
            this.callback.drawRoutes(nArray[i2], (AMapNaviPath)object);
            this.routeTab[i2].setVisibility(0);
            this.mRouteTabTime[i2].setText((CharSequence)gz.c(((AMapNaviPath)object).getAllTime()));
            this.mRouteTabDistance[i2].setText((CharSequence)(String.format("%.1f", Float.valueOf((float)((AMapNaviPath)object).getAllLength() / 1000.0f)) + "\u516c\u91cc"));
            object = ((AMapNaviPath)object).getLabels();
            if (((String)object).contains(string2)) {
                object = ((String)object).substring(0, ((String)object).indexOf(string2));
            }
            this.mRouteTabStrategy[i2].setText((CharSequence)object);
        }
    }

    public void showLoading() {
        this.loadingView.showLoading();
        this.loadingView.setVisibility(0);
        this.tabInfoLayout.setVisibility(4);
    }

    public void hideLoading() {
        this.loadingView.hideLoading();
        this.loadingView.setVisibility(8);
        this.tabInfoLayout.setVisibility(0);
    }

    public void showFailedLoading(String string2) {
        this.loadingView.setVisibility(0);
        this.loadingView.showFailed(string2, this);
        this.tabInfoLayout.setVisibility(4);
    }

    public void setMultipleRouteLayoutVisible(boolean bl2) {
        if (this.multipleRouteLayout != null) {
            this.multipleRouteLayout.setVisibility(bl2 ? 0 : 8);
        }
    }

    public void setSingleRouteLayoutVisible(boolean bl2) {
        if (this.singleRouteLayout != null) {
            this.singleRouteLayout.setVisibility(bl2 ? 0 : 8);
        }
    }

    public void setGuideData(String string2, String string3, int n2) {
        if (this.naviGuideWidget != null) {
            this.naviGuideWidget.setGuideData(string2, string3, this.getGuideGroup(n2));
        }
    }

    public void updateRouteInfo(String string2) {
        if (this.mRouteInfo != null) {
            this.mRouteInfo.setText((CharSequence)string2);
        }
    }

    public void updateLimitForbiddenInfo(String string2) {
        if (this.mLimitForbiddenInfo != null) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.mLimitForbiddenInfo.setText((CharSequence)string2);
                this.mLimitForbiddenInfo.setVisibility(0);
                return;
            }
            this.mLimitForbiddenInfo.setVisibility(8);
        }
    }

    public void updateSingleRouteInfo(String string2) {
        if (this.singleRouteText != null) {
            this.singleRouteText.setText((CharSequence)string2);
        }
    }

    public Button getTopNaviButton() {
        return this.mTopNaviButton;
    }

    public boolean isLoadingShowing() {
        return this.loadingView.isShowing();
    }

    public void onClick(View view) {
        try {
            if (this.listener != null) {
                this.listener.onClick(view);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private List<AMapNaviRouteGuideGroup> getGuideGroup(int n2) {
        try {
            HashMap<Integer, AMapNaviPath> hashMap = AMapNavi.getInstance(this.getContext()).getNaviPaths();
            if (hashMap == null || hashMap.isEmpty()) {
                return null;
            }
            AMapNaviPath aMapNaviPath = hashMap.get(n2);
            if (aMapNaviPath == null) {
                return null;
            }
            return new ArrayList<AMapNaviRouteGuideGroup>(aMapNaviPath.getNaviGuideList());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static interface ISlidingCallback {
        public boolean selectRoute(int var1);

        public void drawRoutes(int var1, AMapNaviPath var2);
    }
}

