/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.amap.api.col.3n.hc;

public class TrafficButtonView
extends ImageView {
    private boolean mIsTrafficOpen;
    private Bitmap trafficCloseBitmap;
    private Bitmap trafficOpenBitmap;
    private Drawable mDefaultImageDay;
    private Drawable mDefaultImageNight;
    private Drawable mDefaultBackgroundDay;
    private Drawable mDefaultBackgroundNight;

    public TrafficButtonView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initBackground();
    }

    public TrafficButtonView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initBackground();
    }

    public TrafficButtonView(Context context) {
        super(context);
        this.initBackground();
    }

    private void initBackground() {
        try {
            Resources resources = hc.b(this.getContext());
            this.mDefaultImageDay = resources.getDrawable(2130838247);
            this.mDefaultImageNight = resources.getDrawable(2130838250);
            this.mDefaultBackgroundDay = resources.getDrawable(2130838204);
            this.mDefaultBackgroundNight = resources.getDrawable(2130838207);
            TrafficButtonView trafficButtonView = this;
            trafficButtonView.setImageDrawable(trafficButtonView.mDefaultImageDay);
            TrafficButtonView trafficButtonView2 = this;
            trafficButtonView2.setBackground(trafficButtonView2.mDefaultBackgroundDay);
            this.setIsTrafficOpen(true);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void reDrawBackground(Bitmap bitmap, Bitmap bitmap2) {
        try {
            this.trafficOpenBitmap = bitmap;
            this.trafficCloseBitmap = bitmap2;
            TrafficButtonView trafficButtonView = this;
            trafficButtonView.setIsTrafficOpen(trafficButtonView.mIsTrafficOpen);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean getIsTrafficOpen() {
        return this.mIsTrafficOpen;
    }

    public void setIsTrafficOpen(boolean bl2) {
        try {
            this.mIsTrafficOpen = bl2;
            if (this.trafficOpenBitmap == null || this.trafficCloseBitmap == null) {
                this.setSelected(bl2);
                return;
            }
            this.setImageBitmap(bl2 ? this.trafficOpenBitmap : this.trafficCloseBitmap);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void recycleResource() {
        try {
            if (this.trafficCloseBitmap != null) {
                this.trafficCloseBitmap.recycle();
            }
            if (this.trafficOpenBitmap != null) {
                this.trafficOpenBitmap.recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void processNightMode(boolean bl2) {
        if (this.trafficOpenBitmap != null && this.trafficCloseBitmap != null) {
            return;
        }
        this.setImageDrawable(bl2 ? this.mDefaultImageNight : this.mDefaultImageDay);
        this.setBackground(bl2 ? this.mDefaultBackgroundNight : this.mDefaultBackgroundDay);
    }
}

