/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view.statusbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.amap.api.col.3n.gz;
import com.amap.api.col.3n.hc;
import com.amap.api.col.3n.hr;
import com.amap.api.navi.view.nightmode.NightMode;

public class StatusBarBatteryProgressView
extends View
implements NightMode {
    private Paint mPaint = null;
    private int mPercent = -1;
    private boolean mChargingBool = false;
    private int mRectRadius = 0;
    private int mViewWidth = 0;
    private int mViewHeight = 0;
    private RectF mRect = null;
    private boolean mNavigationBool = true;
    private Resources mResources;
    boolean isNight = false;

    public StatusBarBatteryProgressView(Context context) {
        this(context, null);
    }

    public StatusBarBatteryProgressView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StatusBarBatteryProgressView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mResources = hc.b(context);
        this.mRect = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.getContext();
        switch (hr.a()) {
            case b: {
                if (gz.d(this.getContext()) != 2) {
                    this.mRectRadius = gz.a(context, 2);
                    return;
                }
                this.mRectRadius = gz.a(context, 1);
                return;
            }
        }
        this.mRectRadius = gz.a(context, 1);
    }

    public void setNavigationBool(boolean bl2) {
        this.mNavigationBool = bl2;
    }

    protected void initWidthHeight(int n2) {
        this.getContext();
        switch (hr.a()) {
            case b: {
                if (n2 != 2) {
                    this.mViewWidth = this.mResources.getDimensionPixelSize(2131165210) - this.mResources.getDimensionPixelSize(2131165213) - this.mResources.getDimensionPixelSize(2131165214);
                    this.mViewHeight = this.mResources.getDimensionPixelSize(2131165225);
                    break;
                }
                this.mViewWidth = this.mResources.getDimensionPixelSize(2131165221) - this.mResources.getDimensionPixelSize(2131165218) - this.mResources.getDimensionPixelSize(2131165219);
                this.mViewHeight = this.mResources.getDimensionPixelSize(2131165216);
                break;
            }
            default: {
                this.mViewWidth = this.mResources.getDimensionPixelSize(2131165221) - this.mResources.getDimensionPixelSize(2131165218) - this.mResources.getDimensionPixelSize(2131165219);
                this.mViewHeight = this.mResources.getDimensionPixelSize(2131165216);
            }
        }
        if (this.mRect == null) {
            this.mRect = new RectF(0.0f, 0.0f, (float)this.mViewWidth, (float)this.mViewHeight);
            return;
        }
        this.mRect.set(0.0f, 0.0f, (float)this.mViewWidth, (float)this.mViewHeight);
    }

    private void requestDraw(boolean bl2) {
        if (this.mPercent == -1) {
            this.mPercent = 0;
        }
        StatusBarBatteryProgressView statusBarBatteryProgressView = this;
        this.mPaint.setColor(statusBarBatteryProgressView.getProgressColor(statusBarBatteryProgressView.mPercent, this.mChargingBool, bl2));
        this.getContext();
        switch (hr.a()) {
            case b: {
                if (gz.d(this.getContext()) != 2) {
                    this.mRect.right = (int)((double)this.mPercent / 100.0 * (double)this.mViewWidth);
                    break;
                }
                this.mRect.left = this.mViewWidth - (int)((double)this.mPercent / 100.0 * (double)this.mViewWidth);
                break;
            }
            default: {
                this.mRect.left = this.mViewWidth - (int)((double)this.mPercent / 100.0 * (double)this.mViewWidth);
            }
        }
        this.invalidate();
    }

    public void processNightMode(boolean bl2) {
        this.isNight = bl2;
        this.requestDraw(bl2);
    }

    public void setProgress(int n2, boolean bl2, boolean bl3) {
        if (n2 > 100) {
            n2 = 100;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (this.mPercent != -1 && !bl3 && this.mPercent == n2 && this.mChargingBool == bl2) {
            return;
        }
        this.mPercent = n2;
        this.mChargingBool = bl2;
        StatusBarBatteryProgressView statusBarBatteryProgressView = this;
        statusBarBatteryProgressView.requestDraw(statusBarBatteryProgressView.mNavigationBool ? this.isNight : false);
    }

    private int getProgressColor(int n2, boolean bl2, boolean bl3) {
        n2 = bl2 ? this.mResources.getColor(2131034155) : (n2 <= 20 ? this.mResources.getColor(2131034153) : (bl3 ? this.mResources.getColor(2131034150) : this.mResources.getColor(2131034151)));
        return n2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mRect.right != 0.0f && this.mRect.bottom != 0.0f) {
            canvas.drawRoundRect(this.mRect, (float)this.mRectRadius, (float)this.mRectRadius, this.mPaint);
        }
    }
}

