/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view.statusbar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class TimeChangeBroadcastReceiver
extends BroadcastReceiver {
    private static TimeChangeBroadcastReceiver mTimeChangeReceiver = null;
    private List<OnTimeChangeCallBack> mCallBackList = new ArrayList<OnTimeChangeCallBack>();

    public static synchronized TimeChangeBroadcastReceiver getInstance() {
        if (mTimeChangeReceiver == null) {
            mTimeChangeReceiver = new TimeChangeBroadcastReceiver();
        }
        return mTimeChangeReceiver;
    }

    private TimeChangeBroadcastReceiver() {
    }

    public void onReceive(Context object, Intent object22) {
        object = object22.getAction();
        if (TextUtils.equals((CharSequence)object, (CharSequence)"android.intent.action.TIME_TICK") || TextUtils.equals((CharSequence)object, (CharSequence)"android.intent.action.TIMEZONE_CHANGED") || TextUtils.equals((CharSequence)object, (CharSequence)"android.intent.action.DATE_CHANGED") || TextUtils.equals((CharSequence)object, (CharSequence)"android.intent.action.TIME_SET")) {
            for (OnTimeChangeCallBack onTimeChangeCallBack : this.mCallBackList) {
                if (onTimeChangeCallBack == null) continue;
                onTimeChangeCallBack.onUpdate();
            }
        }
    }

    public synchronized void addOnTimeChangeCallBack(Context context, OnTimeChangeCallBack onTimeChangeCallBack) {
        if (this.mCallBackList.isEmpty()) {
            this.register(context);
        }
        if (!this.mCallBackList.contains(onTimeChangeCallBack)) {
            this.mCallBackList.add(onTimeChangeCallBack);
        }
    }

    public synchronized void removeOnTimeChangeCallBack(Context context, OnTimeChangeCallBack onTimeChangeCallBack) {
        if (this.mCallBackList.remove(onTimeChangeCallBack) && this.mCallBackList.isEmpty()) {
            this.unRegister(context);
        }
    }

    private void register(Context context) {
        try {
            if (context != null) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.TIME_TICK");
                intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
                intentFilter.addAction("android.intent.action.DATE_CHANGED");
                intentFilter.addAction("android.intent.action.TIME_SET");
                context.registerReceiver((BroadcastReceiver)this, intentFilter);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void unRegister(Context context) {
        try {
            if (context != null) {
                context.unregisterReceiver((BroadcastReceiver)this);
            }
            if (mTimeChangeReceiver != null) {
                mTimeChangeReceiver = null;
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static interface OnTimeChangeCallBack {
        public void onUpdate();
    }
}

