/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.bean;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.amap.api.col.3n.dl;
import com.amap.api.col.3n.p;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.autonavi.base.amap.mapcore.FileUtil;
import com.autonavi.base.amap.mapcore.jbinding.JBindingExclude;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;

@JBindingInclude
public class NativeTextGenerate {
    @JBindingExclude
    private static volatile NativeTextGenerate instance;
    @JBindingExclude
    private TextPaint text_paint = new TextPaint();
    @JBindingExclude
    private float density = 1.0f;
    @JBindingExclude
    private final int kTextLayoutLeftToRight = 0;
    @JBindingExclude
    private final int kTextLayoutUpToDown = 1;
    @JBindingExclude
    private final int kTextAlignmentCenter = 0;
    @JBindingExclude
    private final int kTextAlignmentLeft = 1;
    @JBindingExclude
    private final int kTextAlignmentRight = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JBindingInclude
    public static NativeTextGenerate getInstance() {
        if (instance != null) return instance;
        Class<NativeTextGenerate> clazz = NativeTextGenerate.class;
        synchronized (NativeTextGenerate.class) {
            if (instance != null) return instance;
            instance = new NativeTextGenerate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @JBindingExclude
    private NativeTextGenerate() {
    }

    @JBindingExclude
    public void setDensity(float f2) {
        this.density = f2;
    }

    @JBindingExclude
    private StaticLayout setPaintStyle(TextGenerateTextBitmap textGenerateTextBitmap, TextGenerateTextStyle textGenerateTextStyle, TextGeneratePOIStyleDesc textGeneratePOIStyleDesc) {
        if (textGenerateTextBitmap == null || textGenerateTextStyle == null || textGeneratePOIStyleDesc == null) {
            return null;
        }
        float f2 = (float)textGeneratePOIStyleDesc.fontSize * this.density;
        this.text_paint.setColor(textGeneratePOIStyleDesc.fontColor);
        this.text_paint.setTextSize(f2);
        this.text_paint.setStyle(Paint.Style.FILL);
        this.text_paint.setAntiAlias(true);
        this.text_paint.setFilterBitmap(true);
        this.text_paint.setTypeface(textGeneratePOIStyleDesc.boldFont == 1 ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
        switch (textGenerateTextStyle.textAlignment) {
            case 0: {
                this.text_paint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 2: {
                this.text_paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.text_paint.setTextAlign(Paint.Align.LEFT);
            }
        }
        int n2 = textGenerateTextBitmap.text.length();
        int n3 = textGenerateTextStyle.singleLineCharaterLimit;
        if (n2 > textGenerateTextStyle.singleLineCharaterLimit || n2 % textGenerateTextStyle.singleLineCharaterLimit != 0) {
            int n4 = n2 / textGenerateTextStyle.singleLineCharaterLimit;
            n3 = n2 / (n4 + 1) + (n2 % (n4 + 1) > 0 ? 1 : 0);
        }
        return new StaticLayout((CharSequence)textGenerateTextBitmap.text, this.text_paint, (int)(f2 * (float)n3), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    @JBindingInclude
    void calculateTextBoundSize(TextGenerateTextBitmap textGenerateTextBitmap, TextGenerateTextStyle textGenerateTextStyle, TextGeneratePOIStyleDesc textGeneratePOIStyleDesc) {
        if (textGenerateTextBitmap == null || textGenerateTextStyle == null || textGeneratePOIStyleDesc == null) {
            return;
        }
        textGenerateTextStyle = this.setPaintStyle(textGenerateTextBitmap, textGenerateTextStyle, textGeneratePOIStyleDesc);
        float f2 = this.text_paint.measureText(textGenerateTextBitmap.text);
        Paint.FontMetrics fontMetrics = this.text_paint.getFontMetrics();
        textGenerateTextBitmap.width = f2;
        textGenerateTextBitmap.height = fontMetrics.descent - fontMetrics.ascent;
        textGenerateTextBitmap.width = textGenerateTextStyle.getWidth();
        textGenerateTextBitmap.height = textGenerateTextStyle.getHeight();
    }

    @JBindingInclude
    void generateTextBitmap(TextGenerateTextBitmap textGenerateTextBitmap, TextGenerateTextStyle textGenerateTextStyle, TextGeneratePOIStyleDesc textGeneratePOIStyleDesc) {
        if (textGenerateTextBitmap == null || textGenerateTextStyle == null || textGeneratePOIStyleDesc == null) {
            return;
        }
        this.setPaintStyle(textGenerateTextBitmap, textGenerateTextStyle, textGeneratePOIStyleDesc);
        StaticLayout staticLayout = this.setPaintStyle(textGenerateTextBitmap, textGenerateTextStyle, textGeneratePOIStyleDesc);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)textGenerateTextBitmap.width), (int)((int)textGenerateTextBitmap.height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (textGenerateTextStyle.textAlignment == 0) {
            canvas.translate((float)textGenerateTextBitmap.width / 2.0f, 0.0f);
        } else if (textGenerateTextStyle.textAlignment == 2) {
            canvas.translate((float)textGenerateTextBitmap.width, 0.0f);
        }
        staticLayout.draw(canvas);
        this.text_paint.setStyle(Paint.Style.STROKE);
        this.text_paint.setStrokeWidth(1.0f);
        this.text_paint.setColor(textGeneratePOIStyleDesc.fontBorderColor);
        staticLayout.draw(canvas);
        textGenerateTextBitmap.imageData = BitmapDescriptorFactory.fromBitmap(bitmap);
    }

    @JBindingInclude
    BitmapDescriptor getIconBitmap(String object) {
        if (object == null) {
            return null;
        }
        try {
            Context context = p.a;
            object = (String)object + "_";
            byte[] byArray = FileUtil.uncompress(FileUtil.readFileContentsFromAssetsByPreName(context, "map_assets", (String)object));
            object = byArray;
            if (byArray != null) {
                return BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length));
            }
        }
        catch (Throwable throwable) {
            dl.a(throwable);
        }
        return null;
    }

    @JBindingInclude
    byte[] getMapStyleJsonData() {
        try {
            String string2 = "map_custom/terrain/terrainStyle.data";
            return FileUtil.uncompress(FileUtil.readFileContentsFromAssets(p.a, string2));
        }
        catch (Throwable throwable) {
            dl.a(throwable);
            return null;
        }
    }

    @JBindingInclude
    class TextGeneratePOIStyleDesc {
        int fontSize = 0;
        int fontColor = 0;
        int fontBorderColor = 0;
        int fontBgColor = 0;
        int boldFont = 0;

        TextGeneratePOIStyleDesc() {
        }
    }

    @JBindingInclude
    class TextGenerateTextStyle {
        int singleLineCharaterLimit = 7;
        int textAlignment = 0;
        int layoutDirection = 0;

        TextGenerateTextStyle() {
        }
    }

    @JBindingInclude
    class TextGenerateTextBitmap {
        String text;
        double width;
        double height;
        BitmapDescriptor imageData;

        TextGenerateTextBitmap() {
        }
    }
}

