/*
 * Decompiled with CFR 0.152.
 */
package com.glidebitmappool;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Build;
import android.util.TypedValue;
import com.glidebitmappool.GlideBitmapPool;
import com.glidebitmappool.internal.Util;
import java.io.FileDescriptor;
import java.io.InputStream;

public class GlideBitmapFactory {
    public static Bitmap decodeFile(String pathName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeFile(String pathName, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeResource(Resources res, int id) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeResource(Resources res, int id, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeStream(InputStream is) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeStream(InputStream is, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        options.inSampleSize = 1;
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        }
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        options.inSampleSize = Util.calculateInSampleSize(options, reqWidth, reqHeight);
        if (Build.VERSION.SDK_INT > 11) {
            options.inMutable = true;
            Bitmap inBitmap = GlideBitmapPool.getBitmap(options.outWidth, options.outHeight, options.inPreferredConfig);
            if (inBitmap != null && Util.canUseForInBitmap(inBitmap, options)) {
                options.inBitmap = inBitmap;
            }
        }
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT > 11) {
                options.inBitmap = null;
            }
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)options);
        }
    }
}

