/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.runtime.dfa;

import com.google.repacked.antlr.v4.runtime.dfa.AbstractEdgeMap;
import com.google.repacked.antlr.v4.runtime.dfa.EdgeMap;
import com.google.repacked.antlr.v4.runtime.dfa.SingletonEdgeMap;
import com.google.repacked.antlr.v4.runtime.dfa.SparseEdgeMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ArrayEdgeMap<T>
extends AbstractEdgeMap<T> {
    private final AtomicReferenceArray<T> arrayData;
    private final AtomicInteger size;

    /*
     * WARNING - void declaration
     */
    public ArrayEdgeMap(int minIndex, int maxIndex) {
        super(minIndex, maxIndex);
        void var1_1;
        void var2_2;
        this.arrayData = new AtomicReferenceArray((int)(var2_2 - var1_1 + true));
        this.size = new AtomicInteger();
    }

    @Override
    public final boolean isEmpty() {
        ArrayEdgeMap arrayEdgeMap = this;
        return arrayEdgeMap.size.get() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T get(int key) {
        void var1_1;
        if (key < this.minIndex || key > this.maxIndex) {
            return null;
        }
        return this.arrayData.get((int)(var1_1 - this.minIndex));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ArrayEdgeMap<T> put(int key, T value) {
        if (key >= this.minIndex && key <= this.maxIndex) {
            void var2_3;
            void var1_2;
            T existing = this.arrayData.getAndSet(key - this.minIndex, value);
            if (existing == null && value != null) {
                this.size.incrementAndGet();
            } else if (var1_2 != null && var2_3 == null) {
                this.size.decrementAndGet();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final ArrayEdgeMap<T> putAll(EdgeMap<? extends T> m) {
        void var1_1;
        if (m.isEmpty()) {
            return this;
        }
        if (m instanceof ArrayEdgeMap) {
            ArrayEdgeMap other = (ArrayEdgeMap)m;
            int minOverlap = Math.max(this.minIndex, other.minIndex);
            int maxOverlap = Math.min(this.maxIndex, other.maxIndex);
            AbstractEdgeMap result = this;
            for (void i = var3_7; i <= maxOverlap; ++i) {
                result = result.put((int)i, (Object)m.get((int)i));
            }
            return result;
        }
        if (m instanceof SingletonEdgeMap) {
            SingletonEdgeMap other = (SingletonEdgeMap)m;
            assert (!other.isEmpty());
            return this.put(other.getKey(), other.getValue());
        }
        if (m instanceof SparseEdgeMap) {
            SparseEdgeMap other;
            SparseEdgeMap sparseEdgeMap = other = (SparseEdgeMap)m;
            synchronized (other) {
                int[] keys = other.getKeys();
                List values = other.getValues();
                AbstractEdgeMap result = this;
                for (int i = 0; i < values.size(); ++i) {
                    result = result.put(keys[i], values.get(i));
                }
                // ** MonitorExit[var3_8] (shouldn't be in output)
                return result;
            }
        }
        throw new UnsupportedOperationException(String.format("EdgeMap of type %s is supported yet.", var1_1.getClass().getName()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<Integer, T> toMap() {
        void var1_1;
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, void> result = new LinkedHashMap<Integer, void>();
        for (int i = 0; i < this.arrayData.length(); ++i) {
            void var3_3;
            T element = this.arrayData.get(i);
            if (element == null) continue;
            result.put(i + this.minIndex, var3_3);
        }
        return var1_1;
    }
}

